/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr;

import com.fr.third.antlr.CharFormatter;
import com.fr.third.antlr.Grammar;
import com.fr.third.antlr.LexerGrammar;
import com.fr.third.antlr.collections.impl.BitSet;
import com.fr.third.antlr.collections.impl.Vector;

public class Lookahead
implements Cloneable {
    BitSet fset;
    String cycle;
    BitSet epsilonDepth;
    boolean hasEpsilon = false;

    public Lookahead() {
        this.fset = new BitSet();
    }

    public Lookahead(BitSet p) {
        this.fset = p;
    }

    public Lookahead(String c) {
        this();
        this.cycle = c;
    }

    public Object clone() {
        Lookahead p = null;
        try {
            p = (Lookahead)super.clone();
            p.fset = (BitSet)this.fset.clone();
            p.cycle = this.cycle;
            if (this.epsilonDepth != null) {
                p.epsilonDepth = (BitSet)this.epsilonDepth.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return p;
    }

    public void combineWith(Lookahead q) {
        if (this.cycle == null) {
            this.cycle = q.cycle;
        }
        if (q.containsEpsilon()) {
            this.hasEpsilon = true;
        }
        if (this.epsilonDepth != null) {
            if (q.epsilonDepth != null) {
                this.epsilonDepth.orInPlace(q.epsilonDepth);
            }
        } else if (q.epsilonDepth != null) {
            this.epsilonDepth = (BitSet)q.epsilonDepth.clone();
        }
        this.fset.orInPlace(q.fset);
    }

    public boolean containsEpsilon() {
        return this.hasEpsilon;
    }

    public Lookahead intersection(Lookahead q) {
        Lookahead p = new Lookahead(this.fset.and(q.fset));
        if (this.hasEpsilon && q.hasEpsilon) {
            p.setEpsilon();
        }
        return p;
    }

    public boolean nil() {
        return this.fset.nil() && !this.hasEpsilon;
    }

    public static Lookahead of(int el) {
        Lookahead look = new Lookahead();
        look.fset.add(el);
        return look;
    }

    public void resetEpsilon() {
        this.hasEpsilon = false;
    }

    public void setEpsilon() {
        this.hasEpsilon = true;
    }

    public String toString() {
        String e = "";
        String f = "";
        String d = "";
        String b = this.fset.toString(",");
        if (this.containsEpsilon()) {
            e = "+<epsilon>";
        }
        if (this.cycle != null) {
            f = "; FOLLOW(" + this.cycle + ")";
        }
        if (this.epsilonDepth != null) {
            d = "; depths=" + this.epsilonDepth.toString(",");
        }
        return b + e + f + d;
    }

    public String toString(String separator, CharFormatter formatter) {
        String e = "";
        String f = "";
        String d = "";
        String b = this.fset.toString(separator, formatter);
        if (this.containsEpsilon()) {
            e = "+<epsilon>";
        }
        if (this.cycle != null) {
            f = "; FOLLOW(" + this.cycle + ")";
        }
        if (this.epsilonDepth != null) {
            d = "; depths=" + this.epsilonDepth.toString(",");
        }
        return b + e + f + d;
    }

    public String toString(String separator, CharFormatter formatter, Grammar g) {
        if (g instanceof LexerGrammar) {
            return this.toString(separator, formatter);
        }
        return this.toString(separator, g.tokenManager.getVocabulary());
    }

    public String toString(String separator, Vector vocab) {
        String f = "";
        String d = "";
        String b = this.fset.toString(separator, vocab);
        if (this.cycle != null) {
            f = "; FOLLOW(" + this.cycle + ")";
        }
        if (this.epsilonDepth != null) {
            d = "; depths=" + this.epsilonDepth.toString(",");
        }
        return b + f + d;
    }
}

