/*
 * Decompiled with CFR 0.152.
 */
package com.linkage.netmsg;

import com.linkage.netmsg.HeartBeatInit;
import com.linkage.netmsg.MsgConst;
import com.linkage.netmsg.NetMd5;
import com.linkage.netmsg.server.Parse;
import com.linkage.netmsg.server.ReceiveMsg;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Calendar;

public class NetMsgclient
implements Runnable {
    public Socket socket;
    public Socket heartSocket;
    protected InputStream input = null;
    protected OutputStream output = null;
    public static int seq = 0;
    public static int flag = 0;
    public static boolean result;
    public ReceiveMsg receiveMsg;
    public boolean isStoped = false;
    public String ipAddress;
    public int port;
    public String username;
    public String password;

    public void connect(String host, int port) throws IOException {
        if (!this.socket.isConnected()) {
            InetSocketAddress endpoint = new InetSocketAddress(host, port);
            this.socket.connect(endpoint, 10000);
        }
    }

    public NetMsgclient reconnect() {
        try {
            this.socket = new Socket();
            InetSocketAddress endpoint = new InetSocketAddress(this.ipAddress, this.port);
            this.socket.connect(endpoint, 10000);
            System.out.println("\u91cd\u65b0\u8fde\u63a5\u6210\u529f");
            int isLogin = this.msgRequest(this.username, this.password);
            if (isLogin == 4) {
                do {
                    this.finalClose();
                    this.socket = new Socket();
                    this.socket.connect(endpoint, 10000);
                } while ((isLogin = this.msgRequest(this.username, this.password)) != 0);
            } else if (isLogin == 0) {
                System.out.println("\u91cd\u65b0\u767b\u5f55\u6210\u529f");
            } else {
                System.out.println("\u7f51\u7edc\u5f02\u5e38,\u91cd\u65b0\u81ea\u52a8\u767b\u5f55\u5931\u8d25");
            }
            this.sendHeartBeat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public void finalClose() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
                this.input = null;
                this.output = null;
                if (this.socket == null) {
                    System.out.println("\u8fde\u63a5\u5f02\u5e38\uff0c\u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void connect() throws IOException {
        if (!this.socket.isConnected()) {
            InetSocketAddress endpoint = new InetSocketAddress(this.ipAddress, this.port);
            this.socket.connect(endpoint, 10000);
        }
    }

    public void disconnect() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void forceDisconnect() throws IOException {
        this.socket.close();
    }

    public boolean anthenMsg(NetMsgclient netMsgclient) throws IOException {
        int isLogin = netMsgclient.msgRequest(this.username, this.password);
        if (isLogin == 4) {
            do {
                this.finalClose();
                this.isStoped = true;
                this.socket = new Socket();
                InetSocketAddress endpoint = new InetSocketAddress(this.ipAddress, this.port);
                this.socket.connect(endpoint, 10000);
            } while ((isLogin = this.msgRequest(this.username, this.password)) != 0);
        }
        boolean isSucess = isLogin == 0;
        netMsgclient.run();
        this.sendHeartBeat();
        return isSucess;
    }

    public void sendHeartBeat() throws IOException {
        HeartBeatInit beatInit = new HeartBeatInit();
        beatInit.initHeartBeatTask(this.socket);
    }

    public int msgRequest(String account, String verifyCode) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_REQ.clone();
        byte[] usrBuf = account.getBytes();
        byte[] pwdBuf = NetMd5.GetByteMD5(String.valueOf(account) + verifyCode);
        int length = 0;
        length = (short)(length + 6);
        short a_length = (short)(4 + usrBuf.length);
        short v_length = (short)(4 + pwdBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + v_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)2);
        byteBuf.putShort(a_length);
        byteBuf.put(usrBuf);
        byteBuf.putShort((short)3);
        byteBuf.putShort(v_length);
        byteBuf.put(pwdBuf);
        return this.checkResponse(this.send(byteBuf.array(), 14));
    }

    public int recordQFS(String srcPhone, String recPhone, String msg) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] srcPhoneBuf = srcPhone.getBytes();
        byte[] msgBuf = msg.getBytes();
        int length = 0;
        int seq = NetMsgclient.getSeq();
        length = (short)(length + 6);
        short a_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short e_length = (short)(4 + srcPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + c_length + d_length + e_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)8);
        byteBuf.putShort(e_length);
        byteBuf.put(srcPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        return this.checkBodyResponse(this.send(byteBuf.array(), 22));
    }

    public String recordLDF(int enterpriseId, String srcPhone, String recPhone, String msg) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] srcPhoneBuf = srcPhone.getBytes();
        byte[] msgBuf = msg.getBytes();
        int length = 0;
        int seq = NetMsgclient.getSeq();
        length = (short)(length + 6);
        short a_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        short e_length = 8;
        short f_length = (short)(4 + srcPhoneBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + c_length + d_length + e_length + f_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        byteBuf.putShort((short)9);
        byteBuf.putShort(e_length);
        byteBuf.putInt(enterpriseId);
        byteBuf.putShort((short)8);
        byteBuf.putShort(f_length);
        byteBuf.put(srcPhoneBuf);
        return this.send(byteBuf.array(), 22, seq);
    }

    public String recordCommon(int sendType, String recPhone, String msg, int isNeedReport) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] msgBuf = msg.getBytes("GBK");
        int length = 0;
        int seq = this.getSeqId();
        length = (short)(length + 6);
        short a_length = 8;
        short b_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        short e_length = 8;
        Pattern[1] = length = (int)((short)(length + a_length + b_length + c_length + d_length + e_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)5);
        byteBuf.putShort(b_length);
        byteBuf.putInt(sendType);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        byteBuf.putShort((short)10);
        byteBuf.putShort(e_length);
        byteBuf.putInt(isNeedReport);
        return this.send(byteBuf.array(), 47, seq);
    }

    public String sendLdf(String srcPhone, String recPhone, String feeNum, String msg, int isNeedReport) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] srcPhoneBuf = srcPhone.getBytes();
        byte[] feeNumBuf = feeNum.getBytes();
        byte[] msgBuf = msg.getBytes();
        int length = 0;
        int seq = NetMsgclient.getSeq();
        length = (short)(length + 6);
        short a_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        short e_length = (short)(4 + feeNumBuf.length);
        short f_length = (short)(4 + srcPhoneBuf.length);
        short g_length = 8;
        Pattern[1] = length = (int)((short)(length + a_length + c_length + d_length + e_length + f_length + g_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        byteBuf.putShort((short)23);
        byteBuf.putShort(e_length);
        byteBuf.put(feeNumBuf);
        byteBuf.putShort((short)8);
        byteBuf.putShort(f_length);
        byteBuf.put(srcPhoneBuf);
        byteBuf.putShort((short)10);
        byteBuf.putShort(g_length);
        byteBuf.putInt(isNeedReport);
        return this.send(byteBuf.array(), 22, seq);
    }

    public String sendMsg(NetMsgclient netMsgclient, int sendType, String recPhone, String msg, int isNeedReport) {
        String result = "";
        if (netMsgclient == null || netMsgclient.socket == null || netMsgclient.socket.isClosed()) {
            return "16";
        }
        try {
            result = netMsgclient.recordCommon(sendType, recPhone, msg, isNeedReport);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getSeqId() {
        Calendar cal = Calendar.getInstance();
        long hour = cal.get(11);
        long minute = cal.get(12);
        long second = cal.get(13);
        long time = hour * 10000L + minute * 100L + second;
        int seq = NetMsgclient.getSeq();
        String seqStr = NetMsgclient.getFormatNum(seq, 3);
        int seqId = Integer.parseInt(String.valueOf(String.valueOf(time)) + seqStr);
        return seqId;
    }

    public static synchronized int getSeq() {
        seq = seq >= 999 ? 1 : ++seq;
        return seq;
    }

    public static String getFormatNum(long data, int len) {
        String lenStr = String.valueOf(data);
        while (lenStr.length() < len) {
            lenStr = "0" + lenStr;
        }
        if (lenStr.length() > len) {
            lenStr = lenStr.substring(lenStr.length() - len, lenStr.length());
        }
        return lenStr;
    }

    public byte[] ints2bytes(short[] num) {
        int len = num.length * 4;
        byte[] b = new byte[len];
        int i = 0;
        while (i < num.length) {
            int j = 0;
            while (j < 4) {
                b[i * 4 + j] = (byte)(num[i] >>> 24 - j * 8);
                ++j;
            }
            ++i;
        }
        return b;
    }

    protected byte[] send(byte[] data, int rep_size) throws IOException {
        try {
            if (this.input == null) {
                this.input = new DataInputStream(this.socket.getInputStream());
            }
            if (this.output == null) {
                this.output = new DataOutputStream(this.socket.getOutputStream());
            }
            this.output.write(data);
            this.output.flush();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        byte[] rep = new byte[rep_size];
        for (int Timeout = 15000; this.input.available() < rep_size && Timeout > 0; Timeout -= 5) {
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.input.read(rep);
        return rep;
    }

    protected String send(byte[] data, int rep_size, int seqId) throws IOException {
        try {
            if (this.input == null) {
                this.input = new DataInputStream(this.socket.getInputStream());
            }
            if (this.output == null) {
                this.output = new DataOutputStream(this.socket.getOutputStream());
            }
            this.output.write(data);
            this.output.flush();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        String returnValue = NetMsgclient.getFormatNum(seqId, 9);
        return returnValue;
    }

    protected byte[] send2(byte[] data, int rep_size, Socket socket) throws IOException {
        try {
            if (this.input == null) {
                this.input = new DataInputStream(socket.getInputStream());
            }
            if (this.output == null) {
                this.output = new DataOutputStream(socket.getOutputStream());
            }
            this.output.write(data);
            this.output.flush();
        }
        catch (SocketException e) {
            socket = new Socket();
            InetSocketAddress endpoint = new InetSocketAddress(this.ipAddress, this.port);
            socket.connect(endpoint, 10000);
            this.output.write(data);
            this.output.flush();
        }
        byte[] rep = new byte[rep_size];
        return rep;
    }

    public NetMsgclient initParameters(String ipAddress, int port, String username, String password, ReceiveMsg receiveMsg) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.username = username;
        this.password = password;
        this.receiveMsg = receiveMsg;
        if (this.socket == null) {
            this.socket = new Socket();
        }
        InetSocketAddress endpoint = new InetSocketAddress(ipAddress, port);
        try {
            this.socket.connect(endpoint, 10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public static void main(String[] args) {
    }

    public int checkHeadResponse(byte[] rep) {
        int ret = -1;
        ByteBuffer buf = ByteBuffer.wrap(rep);
        buf.getShort();
        buf.getShort();
        short headType = buf.getShort();
        if (headType == MsgConst.NET_HEAD_RSP[2]) {
            buf.getShort();
            buf.getShort();
            ret = buf.getInt();
        }
        return ret;
    }

    public int checkBodyResponse(byte[] rep) {
        String messId = "";
        int ret = -1;
        ByteBuffer buf = ByteBuffer.wrap(rep);
        buf.getShort();
        buf.getShort();
        short headType = buf.getShort();
        if (headType == MsgConst.NET_HEAD_BODY_RSP[2]) {
            while (buf.remaining() > 0) {
                short length;
                short type = buf.getShort();
                if (type == 1) {
                    length = buf.getShort();
                    ret = buf.getInt();
                    continue;
                }
                if (type == 11) {
                    length = buf.getShort();
                    ByteBuffer buf2 = buf.get(new byte[length - 25]);
                    Charset charset = null;
                    CharsetDecoder decoder = null;
                    CharBuffer charBuffer = null;
                    try {
                        charset = Charset.forName("gb2312");
                        decoder = charset.newDecoder();
                        charBuffer = decoder.decode(buf2);
                        messId = charBuffer.toString();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                length = buf.getShort();
                buf.position(buf.position() + length - 4);
            }
        }
        return ret;
    }

    public String checkNeedBodyResponse(byte[] rep) {
        return "0";
    }

    public int checkResponse(byte[] rep) {
        ByteBuffer buf = ByteBuffer.wrap(rep);
        buf.getShort();
        buf.getShort();
        buf.getShort();
        buf.getShort();
        buf.getShort();
        int ret = buf.getInt();
        return ret;
    }

    public void closeConn() {
        this.isStoped = true;
        if (this.socket.isConnected()) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        try {
            Parse child = new Parse(this);
            new Thread(child).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run2(NetMsgclient netMsgclient) {
    }
}

