/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.directwebremoting.dwrp.SimpleOutboundVariable;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class DefaultConverterManager
implements ConverterManager {
    private Map extraTypeInfoMap = new HashMap();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$dwrp$DefaultConverterManager == null ? (class$org$directwebremoting$dwrp$DefaultConverterManager = DefaultConverterManager.class$("org.directwebremoting.dwrp.DefaultConverterManager")) : class$org$directwebremoting$dwrp$DefaultConverterManager);
    private Map converterTypes = new HashMap();
    private Map converters = new HashMap();
    private static List ignore = Arrays.asList("converter", "match");
    static /* synthetic */ Class class$org$directwebremoting$extend$Converter;
    static /* synthetic */ Class class$org$directwebremoting$dwrp$DefaultConverterManager;

    public void addConverterType(String id, String className) {
        if (!LocalUtil.isJavaIdentifier(id)) {
            log.error("Illegal identifier: '" + id + "'");
            return;
        }
        Class clazz = LocalUtil.classForName(id, className, class$org$directwebremoting$extend$Converter == null ? (class$org$directwebremoting$extend$Converter = DefaultConverterManager.class$("org.directwebremoting.extend.Converter")) : class$org$directwebremoting$extend$Converter);
        if (clazz != null) {
            log.debug("- adding converter type: " + id + " = " + clazz.getName());
            this.converterTypes.put(id, clazz);
        }
    }

    public void addConverter(String match, String type, Map params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class clazz = (Class)this.converterTypes.get(type);
        if (clazz == null) {
            log.info("Probably not an issue: " + match + " is not available so the " + type + " converter will not load. This is only an problem if you wanted to use it.");
            return;
        }
        Converter converter = (Converter)clazz.newInstance();
        converter.setConverterManager(this);
        LocalUtil.setParams(converter, params, ignore);
        this.addConverter(match, converter);
    }

    public void addConverter(String match, Converter converter) throws IllegalArgumentException {
        Converter other = (Converter)this.converters.get(match);
        if (other != null) {
            log.warn("Clash of converters for " + match + ". Using " + converter.getClass().getName() + " in place of " + other.getClass().getName());
        }
        log.debug("- adding converter: " + LocalUtil.getShortClassName(converter.getClass()) + " for " + match);
        this.converters.put(match, converter);
    }

    public Collection getConverterMatchStrings() {
        return Collections.unmodifiableSet(this.converters.keySet());
    }

    public Converter getConverterByMatchString(String match) {
        return (Converter)this.converters.get(match);
    }

    public boolean isConvertable(Class paramType) {
        return this.getConverter(paramType) != null;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx, TypeHintContext incc) throws MarshallException {
        Object converted = inctx.getConverted(iv, paramType);
        if (converted == null) {
            Converter converter = this.getNamedConverter(paramType, iv.getType());
            if (converter == null) {
                converter = this.getConverter(paramType);
            }
            if (converter == null) {
                throw new MarshallException(paramType, Messages.getString("DefaultConverterManager.MissingConverter", paramType));
            }
            if (iv.isNull()) {
                return null;
            }
            inctx.pushContext(incc);
            converted = converter.convertInbound(paramType, iv, inctx);
            inctx.popContext();
        }
        return converted;
    }

    public OutboundVariable convertOutbound(Object object, OutboundContext outctx) throws MarshallException {
        if (object == null) {
            return new SimpleOutboundVariable("null", outctx, true);
        }
        OutboundVariable ov = outctx.get(object);
        if (ov != null) {
            return ov.getReferenceVariable();
        }
        Converter converter = this.getConverter(object);
        if (converter == null) {
            log.error(Messages.getString("DefaultConverterManager.MissingConverter", object.getClass().getName()));
            return new SimpleOutboundVariable("null", outctx, true);
        }
        return converter.convertOutbound(object, outctx);
    }

    public void setExtraTypeInfo(TypeHintContext thc, Class type) {
        this.extraTypeInfoMap.put(thc, type);
    }

    public Class getExtraTypeInfo(TypeHintContext thc) {
        Class type = (Class)this.extraTypeInfoMap.get(thc);
        return type;
    }

    public void setConverters(Map converters) {
        this.converters = converters;
    }

    private Converter getConverter(Object object) {
        if (object == null) {
            return this.getConverter(Void.TYPE);
        }
        return this.getConverter(object.getClass());
    }

    protected Converter getNamedConverter(Class paramType, String type) throws MarshallException {
        if (type.startsWith("Object_")) {
            String javascriptClassName = type.substring("Object_".length());
            Iterator it = this.converters.entrySet().iterator();
            while (it.hasNext()) {
                NamedConverter boConv;
                Map.Entry entry = it.next();
                String match = (String)entry.getKey();
                Converter conv = (Converter)entry.getValue();
                if (!(conv instanceof NamedConverter) || (boConv = (NamedConverter)conv).getJavascript() == null || !boConv.getJavascript().equals(javascriptClassName)) continue;
                try {
                    Class inboundClass = LocalUtil.classForName(match);
                    if (!paramType.isAssignableFrom(inboundClass)) continue;
                    boConv.setInstanceType(inboundClass);
                    return boConv;
                }
                catch (ClassNotFoundException ex) {
                    throw new MarshallException(paramType, (Throwable)ex);
                }
            }
        }
        return null;
    }

    private Converter getConverter(Class paramType) {
        block7: {
            Converter converter = this.getConverterAssignableFrom(paramType);
            if (converter != null) {
                return converter;
            }
            String lookup = paramType.getName();
            if (lookup.startsWith("$Proxy") && (converter = (Converter)this.converters.get("$Proxy*")) != null) {
                return converter;
            }
            while (true) {
                if ((converter = (Converter)this.converters.get(lookup + ".*")) != null) {
                    return converter;
                }
                converter = (Converter)this.converters.get(lookup + '*');
                if (converter != null) {
                    return converter;
                }
                if (lookup.length() == 0) break block7;
                int lastdot = lookup.lastIndexOf(46);
                if (lastdot != -1) {
                    lookup = lookup.substring(0, lastdot);
                    continue;
                }
                int arrayMarkers = 0;
                while (lookup.charAt(arrayMarkers) == '[') {
                    ++arrayMarkers;
                }
                if (arrayMarkers == 0) break block7;
                converter = (Converter)this.converters.get(lookup = lookup.substring(arrayMarkers - 1, arrayMarkers + 1));
                if (converter != null) break;
            }
            return converter;
        }
        return null;
    }

    private Converter getConverterAssignableFrom(Class paramType) {
        if (paramType == null) {
            return null;
        }
        String lookup = paramType.getName();
        Converter converter = (Converter)this.converters.get(lookup);
        if (converter != null) {
            return converter;
        }
        Class<?>[] interfaces = paramType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            converter = this.getConverterAssignableFrom(interfaces[i]);
            if (converter == null) continue;
            this.converters.put(lookup, converter);
            return converter;
        }
        converter = this.getConverterAssignableFrom(paramType.getSuperclass());
        if (converter != null) {
            this.converters.put(lookup, converter);
        }
        return converter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

