/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.util.io.BitOutputStream;

public class SWFShape {
    private int numFillBits;
    private int numLineBits;
    protected FillStyleArray fillStyles;
    protected LineStyleArray lineStyles;
    private Vector records;

    public SWFShape(Vector vector) {
        this.records = vector;
    }

    public SWFShape(SWFInputStream sWFInputStream) throws IOException {
        this(sWFInputStream, null, null, false, false, false);
    }

    public SWFShape(SWFInputStream sWFInputStream, FillStyleArray fillStyleArray, LineStyleArray lineStyleArray, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.fillStyles = fillStyleArray;
        this.lineStyles = lineStyleArray;
        sWFInputStream.byteAlign();
        this.numFillBits = (int)sWFInputStream.readUBits(4);
        this.numLineBits = (int)sWFInputStream.readUBits(4);
        this.records = new Vector();
        boolean bl4 = false;
        do {
            boolean bl5;
            if (bl5 = sWFInputStream.readBitFlag()) {
                this.records.add(new EdgeRecord(sWFInputStream));
                continue;
            }
            int n2 = (int)sWFInputStream.readUBits(5);
            if (n2 == 0) {
                bl4 = true;
                continue;
            }
            this.records.add(new ShapeRecord(this, sWFInputStream, this.numFillBits, this.numLineBits, bl, bl2, bl3, n2));
        } while (!bl4);
    }

    public void write(SWFOutputStream sWFOutputStream) throws IOException {
        this.write(sWFOutputStream, false, false, false);
    }

    public void write(SWFOutputStream sWFOutputStream, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Record record;
        int n2;
        sWFOutputStream.byteAlign();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.records.size(); ++n2) {
            record = (Record)this.records.get(n2);
            if (!(record instanceof ShapeRecord)) continue;
            ShapeRecord shapeRecord = (ShapeRecord)record;
            n3 = Math.max(n3, shapeRecord.getNumFillBits());
            n4 = Math.max(n4, shapeRecord.getNumLineBits());
        }
        sWFOutputStream.writeUBits(n3, 4);
        sWFOutputStream.writeUBits(n4, 4);
        for (n2 = 0; n2 < this.records.size(); ++n2) {
            record = (Record)this.records.get(n2);
            record.write(sWFOutputStream, n3, n4, bl, bl2, bl3);
        }
        sWFOutputStream.writeUBits(0L, 6);
        sWFOutputStream.byteAlign();
    }

    void setNumFillBits(int n2) {
        this.numFillBits = n2;
    }

    void setNumLineBits(int n2) {
        this.numLineBits = n2;
    }

    void setFillStyles(FillStyleArray fillStyleArray) {
        this.fillStyles = fillStyleArray;
    }

    void setLineStyles(LineStyleArray lineStyleArray) {
        this.lineStyles = lineStyleArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.records.size(); ++i2) {
            stringBuffer.append("    ");
            stringBuffer.append(i2);
            stringBuffer.append(":");
            stringBuffer.append(this.records.get(i2));
            stringBuffer.append("\n");
        }
        stringBuffer.append("    End of shape\n");
        return stringBuffer.toString();
    }

    public static class EdgeRecord
    extends Record {
        boolean curve;
        int controlDeltaX;
        int controlDeltaY;
        int anchorDeltaX;
        int anchorDeltaY;
        int deltaX;
        int deltaY;

        public EdgeRecord(int n2, int n3, int n4, int n5) {
            this.curve = true;
            this.controlDeltaX = n2;
            this.controlDeltaY = n3;
            this.anchorDeltaX = n4;
            this.anchorDeltaY = n5;
        }

        public EdgeRecord(int n2, int n3) {
            this.curve = false;
            this.deltaX = n2;
            this.deltaY = n3;
        }

        EdgeRecord(SWFInputStream sWFInputStream) throws IOException {
            this.curve = !sWFInputStream.readBitFlag();
            int n2 = (int)sWFInputStream.readUBits(4) + 2;
            if (this.curve) {
                this.controlDeltaX = (int)sWFInputStream.readSBits(n2);
                this.controlDeltaY = (int)sWFInputStream.readSBits(n2);
                this.anchorDeltaX = (int)sWFInputStream.readSBits(n2);
                this.anchorDeltaY = (int)sWFInputStream.readSBits(n2);
            } else if (sWFInputStream.readBitFlag()) {
                this.deltaX = (int)sWFInputStream.readSBits(n2);
                this.deltaY = (int)sWFInputStream.readSBits(n2);
            } else if (sWFInputStream.readBitFlag()) {
                this.deltaX = 0;
                this.deltaY = (int)sWFInputStream.readSBits(n2);
            } else {
                this.deltaX = (int)sWFInputStream.readSBits(n2);
                this.deltaY = 0;
            }
        }

        public void write(SWFOutputStream sWFOutputStream, int n2, int n3, boolean bl, boolean bl2, boolean bl3) throws IOException {
            sWFOutputStream.writeBitFlag(true);
            sWFOutputStream.writeBitFlag(!this.curve);
            int n4 = 0;
            if (this.curve) {
                n4 = Math.max(n4, BitOutputStream.minBits(this.controlDeltaX, true));
                n4 = Math.max(n4, BitOutputStream.minBits(this.controlDeltaY, true));
                n4 = Math.max(n4, BitOutputStream.minBits(this.anchorDeltaX, true));
                n4 = Math.max(n4, BitOutputStream.minBits(this.anchorDeltaY, true));
            } else if (this.deltaX != 0 && this.deltaY != 0) {
                n4 = Math.max(n4, BitOutputStream.minBits(this.deltaX, true));
                n4 = Math.max(n4, BitOutputStream.minBits(this.deltaY, true));
            } else {
                n4 = this.deltaX == 0 ? Math.max(n4, BitOutputStream.minBits(this.deltaY, true)) : Math.max(n4, BitOutputStream.minBits(this.deltaX, true));
            }
            sWFOutputStream.writeUBits(n4 - 2, 4);
            if (this.curve) {
                sWFOutputStream.writeSBits(this.controlDeltaX, n4);
                sWFOutputStream.writeSBits(this.controlDeltaY, n4);
                sWFOutputStream.writeSBits(this.anchorDeltaX, n4);
                sWFOutputStream.writeSBits(this.anchorDeltaY, n4);
            } else if (this.deltaX != 0 && this.deltaY != 0) {
                sWFOutputStream.writeBitFlag(true);
                sWFOutputStream.writeSBits(this.deltaX, n4);
                sWFOutputStream.writeSBits(this.deltaY, n4);
            } else {
                sWFOutputStream.writeBitFlag(false);
                if (this.deltaX == 0) {
                    sWFOutputStream.writeBitFlag(true);
                    sWFOutputStream.writeSBits(this.deltaY, n4);
                } else {
                    sWFOutputStream.writeBitFlag(false);
                    sWFOutputStream.writeSBits(this.deltaX, n4);
                }
            }
        }

        public String toString() {
            if (this.curve) {
                return "rcurveto(" + this.controlDeltaX + ", " + this.controlDeltaY + ", " + this.anchorDeltaX + ", " + this.anchorDeltaY + ")";
            }
            return "rlineto(" + this.deltaX + ", " + this.deltaY + ")";
        }
    }

    public static class ShapeRecord
    extends Record {
        private static final int MOVE = 1;
        private static final int FILLSTYLE0 = 2;
        private static final int FILLSTYLE1 = 4;
        private static final int LINESTYLE = 8;
        private static final int NEWSTYLES = 16;
        private boolean move;
        private int moveX = 0;
        private int moveY = 0;
        private int fillStyle0 = -1;
        private int fillStyle1 = -1;
        private int lineStyle = -1;
        private FillStyleArray newFillStyles;
        private LineStyleArray newLineStyles;

        public ShapeRecord(boolean bl, int n2, int n3, int n4, int n5, int n6) {
            this.move = bl;
            this.moveX = n2;
            this.moveY = n3;
            this.fillStyle0 = n4;
            this.fillStyle1 = n5;
            this.lineStyle = n6;
        }

        ShapeRecord(SWFShape sWFShape, SWFInputStream sWFInputStream, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4) throws IOException {
            if ((n4 & 1) > 0) {
                this.move = true;
                int n5 = (int)sWFInputStream.readUBits(5);
                this.moveX = (int)sWFInputStream.readSBits(n5);
                this.moveY = (int)sWFInputStream.readSBits(n5);
            }
            if ((n4 & 2) > 0) {
                this.fillStyle0 = (int)sWFInputStream.readUBits(n2);
            }
            if ((n4 & 4) > 0) {
                this.fillStyle1 = (int)sWFInputStream.readUBits(n2);
            }
            if ((n4 & 8) > 0) {
                this.lineStyle = (int)sWFInputStream.readUBits(n3);
            }
            if ((n4 & 0x10) > 0) {
                this.newFillStyles = new FillStyleArray(sWFInputStream, bl, bl2);
                sWFShape.setFillStyles(this.newFillStyles);
                this.newLineStyles = new LineStyleArray(sWFInputStream, bl, bl2, bl3);
                sWFShape.setLineStyles(this.newLineStyles);
                n2 = (int)sWFInputStream.readUBits(4);
                sWFShape.setNumFillBits(n2);
                n3 = (int)sWFInputStream.readUBits(4);
                sWFShape.setNumLineBits(n3);
            }
        }

        public void write(SWFOutputStream sWFOutputStream, int n2, int n3, boolean bl, boolean bl2, boolean bl3) throws IOException {
            int n4 = 0;
            if (this.newFillStyles != null) {
                n4 |= 0x10;
            }
            if (this.lineStyle != -1) {
                n4 |= 8;
            }
            if (this.fillStyle1 != -1) {
                n4 |= 4;
            }
            if (this.fillStyle0 != -1) {
                n4 |= 2;
            }
            if (this.move) {
                n4 |= 1;
            }
            sWFOutputStream.writeUBits(n4, 6);
            if (this.move) {
                int n5 = Math.max(BitOutputStream.minBits(this.moveX, true), BitOutputStream.minBits(this.moveY, true));
                sWFOutputStream.writeUBits(n5, 5);
                sWFOutputStream.writeSBits(this.moveX, n5);
                sWFOutputStream.writeSBits(this.moveY, n5);
            }
            if (this.fillStyle0 != -1) {
                sWFOutputStream.writeUBits(this.fillStyle0, n2);
            }
            if (this.fillStyle1 != -1) {
                sWFOutputStream.writeUBits(this.fillStyle1, n2);
            }
            if (this.lineStyle != -1) {
                sWFOutputStream.writeUBits(this.lineStyle, n3);
            }
            if (this.newFillStyles != null) {
                this.newFillStyles.write(sWFOutputStream, bl, bl2);
                this.newLineStyles.write(sWFOutputStream, bl, bl2, bl3);
                sWFOutputStream.writeUBits(n2, 4);
                sWFOutputStream.writeUBits(n3, 4);
            }
        }

        public int getNumFillBits() {
            int n2 = 0;
            if (this.fillStyle0 != -1) {
                n2 = Math.max(n2, BitOutputStream.minBits(this.fillStyle0));
            }
            if (this.fillStyle1 != -1) {
                n2 = Math.max(n2, BitOutputStream.minBits(this.fillStyle1));
            }
            return n2;
        }

        public int getNumLineBits() {
            return this.lineStyle != -1 ? BitOutputStream.minBits(this.lineStyle) : 0;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.move) {
                stringBuffer.append("moveto(" + this.moveX + ", " + this.moveY + "); ");
            }
            if (this.fillStyle0 != -1) {
                stringBuffer.append("fillStyle0=" + this.fillStyle0 + "; ");
            }
            if (this.fillStyle1 != -1) {
                stringBuffer.append("fillStyle1=" + this.fillStyle1 + "; ");
            }
            if (this.lineStyle != -1) {
                stringBuffer.append("lineStyle=" + this.lineStyle + "; ");
            }
            if (this.newFillStyles != null || this.newLineStyles != null) {
                stringBuffer.append("More Styles;\n");
            }
            if (this.newFillStyles != null) {
                stringBuffer.append(this.newFillStyles.toString());
            }
            if (this.newLineStyles != null) {
                stringBuffer.append(this.newLineStyles.toString());
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class Record {
        public abstract void write(SWFOutputStream var1, int var2, int var3, boolean var4, boolean var5, boolean var6) throws IOException;
    }
}

