/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.ClipEventFlags;
import org.freehep.graphicsio.swf.SWFAction;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class ClipActionRecord {
    private ClipEventFlags eventFlags;
    private long actionRecordSize;
    private int keyCode;
    private Vector actions;

    public ClipActionRecord(SWFInputStream sWFInputStream) throws IOException {
        this.eventFlags = new ClipEventFlags(sWFInputStream);
        if (this.eventFlags.isEndFlag()) {
            return;
        }
        this.actionRecordSize = sWFInputStream.readUnsignedInt();
        sWFInputStream.pushBuffer((int)(this.actionRecordSize - 4L));
        if (this.eventFlags.isKeyPress()) {
            this.keyCode = sWFInputStream.readUnsignedByte();
        }
        while (sWFInputStream.getLength() > 0L) {
            this.actions.add(sWFInputStream.readAction());
        }
        byte[] byArray = sWFInputStream.popBuffer();
        if (byArray != null) {
            System.err.println("Corrupted ClipActionRecord, " + byArray.length + " bytes leftoever.");
        }
    }

    public void write(SWFOutputStream sWFOutputStream) throws IOException {
        this.eventFlags.write(sWFOutputStream);
        sWFOutputStream.writeUnsignedInt(this.actionRecordSize);
        if (this.eventFlags.isKeyPress()) {
            sWFOutputStream.writeUnsignedByte(this.keyCode);
        }
        for (int i2 = 0; i2 < this.actions.size(); ++i2) {
            SWFAction sWFAction = (SWFAction)this.actions.get(i2);
            sWFOutputStream.writeAction(sWFAction);
        }
    }

    public boolean isEndRecord() {
        return this.eventFlags.isEndFlag();
    }

    public String toString() {
        return "ClipActionRecord " + this.actions.size();
    }
}

