/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Map list = new LinkedHashMap();
    private Set multisegmentNames;
    private Map slist;
    private String lastName = null;
    private static boolean encodeParameters = false;
    private static boolean decodeParameters = false;
    private static boolean decodeParametersStrict = false;
    private static boolean applehack = false;
    private static final char[] hex;

    public ParameterList() {
        if (decodeParameters) {
            this.multisegmentNames = new HashSet();
            this.slist = new HashMap();
        }
    }

    public ParameterList(String string) throws ParseException {
        this();
        HeaderTokenizer.Token token;
        int n2;
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while ((n2 = (token = headerTokenizer.next()).getType()) != -4) {
            String string2;
            if ((char)n2 == ';') {
                token = headerTokenizer.next();
                if (token.getType() == -4) break;
                if (token.getType() != -1) {
                    throw new ParseException("Expected parameter name, got \"" + token.getValue() + "\"");
                }
                String string3 = token.getValue().toLowerCase(Locale.ENGLISH);
                token = headerTokenizer.next();
                if ((char)token.getType() != '=') {
                    throw new ParseException("Expected '=', got \"" + token.getValue() + "\"");
                }
                token = headerTokenizer.next();
                n2 = token.getType();
                if (n2 != -1 && n2 != -2) {
                    throw new ParseException("Expected parameter value, got \"" + token.getValue() + "\"");
                }
                string2 = token.getValue();
                this.lastName = string3;
                if (decodeParameters) {
                    this.putEncodedName(string3, string2);
                    continue;
                }
                this.list.put(string3, string2);
                continue;
            }
            if (applehack && n2 == -1 && this.lastName != null && (this.lastName.equals("name") || this.lastName.equals("filename"))) {
                String string4 = (String)this.list.get(this.lastName);
                string2 = string4 + " " + token.getValue();
                this.list.put(this.lastName, string2);
                continue;
            }
            throw new ParseException("Expected ';', got \"" + token.getValue() + "\"");
        }
        if (decodeParameters) {
            this.combineMultisegmentNames(false);
        }
    }

    private void putEncodedName(String string, String string2) throws ParseException {
        int n2 = string.indexOf(42);
        if (n2 < 0) {
            this.list.put(string, string2);
        } else if (n2 == string.length() - 1) {
            string = string.substring(0, n2);
            this.list.put(string, ParameterList.decodeValue(string2));
        } else {
            Object object;
            String string3 = string.substring(0, n2);
            this.multisegmentNames.add(string3);
            this.list.put(string3, "");
            if (string.endsWith("*")) {
                object = new Value();
                ((Value)object).encodedValue = string2;
                ((Value)object).value = string2;
                string = string.substring(0, string.length() - 1);
            } else {
                object = string2;
            }
            this.slist.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void combineMultisegmentNames(boolean var1_1) throws ParseException {
        block15: {
            block17: {
                block18: {
                    block16: {
                        var2_2 = false;
                        try {
                            var3_3 = this.multisegmentNames.iterator();
                            while (var3_3.hasNext()) {
                                var4_4 = (String)var3_3.next();
                                var5_5 = new StringBuffer();
                                var6_6 = new MultiValue();
                                var7_7 = null;
                                var8_8 = 0;
                                while ((var10_10 = this.slist.get(var9_9 = var4_4 + "*" + var8_8)) != null) {
                                    var6_6.add(var10_10);
                                    var11_11 = null;
                                    if (var10_10 instanceof Value) {
                                        try {
                                            var12_12 = (Value)var10_10;
                                            var11_11 = var13_14 = var12_12.encodedValue;
                                            if (var8_8 == 0) {
                                                var14_16 = ParameterList.decodeValue(var13_14);
                                                var7_7 = var12_12.charset = var14_16.charset;
                                                var11_11 = var12_12.value = var14_16.value;
                                            }
                                            if (var7_7 == null) {
                                                this.multisegmentNames.remove(var4_4);
                                                break;
                                            }
                                            var11_11 = var12_12.value = ParameterList.decodeBytes(var13_14, var7_7);
                                        }
                                        catch (NumberFormatException var12_13) {
                                            if (!ParameterList.decodeParametersStrict) ** GOTO lbl39
                                            throw new ParseException(var12_13.toString());
                                        }
                                        catch (UnsupportedEncodingException var13_15) {
                                            if (!ParameterList.decodeParametersStrict) ** GOTO lbl39
                                            throw new ParseException(var13_15.toString());
                                        }
                                        catch (StringIndexOutOfBoundsException var14_17) {
                                            if (!ParameterList.decodeParametersStrict) ** GOTO lbl39
                                            throw new ParseException(var14_17.toString());
                                        }
                                    } else {
                                        var11_11 = (String)var10_10;
                                    }
lbl39:
                                    // 6 sources

                                    var5_5.append(var11_11);
                                    this.slist.remove(var9_9);
                                    ++var8_8;
                                }
                                if (var8_8 == 0) {
                                    this.list.remove(var4_4);
                                    continue;
                                }
                                var6_6.value = var5_5.toString();
                                this.list.put(var4_4, var6_6);
                            }
                            var2_2 = true;
                            var16_18 = null;
                            if (!var1_1 && !var2_2) break block15;
                            if (this.slist.size() <= 0) break block16;
                            var17_20 = this.slist.values().iterator();
                            ** while (var17_20.hasNext())
                        }
                        catch (Throwable var15_28) {
                            var16_19 = null;
                            if (!var1_1 && !var2_2) break block17;
                            if (this.slist.size() <= 0) break block18;
                            var17_21 = this.slist.values().iterator();
                            ** while (var17_21.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var18_22 = var17_20.next();
                            if (!(var18_22 instanceof Value)) continue;
                            var19_24 = (Value)var18_22;
                            var20_26 = ParameterList.decodeValue(var19_24.encodedValue);
                            var19_24.charset = var20_26.charset;
                            var19_24.value = var20_26.value;
                            continue;
                        }
lbl67:
                        // 1 sources

                        this.list.putAll(this.slist);
                    }
                    this.multisegmentNames.clear();
                    this.slist.clear();
                    {
                        break block15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var18_23 = var17_21.next();
                        if (!(var18_23 instanceof Value)) continue;
                        var19_25 = (Value)var18_23;
                        var20_27 = ParameterList.decodeValue(var19_25.encodedValue);
                        var19_25.charset = var20_27.charset;
                        var19_25.value = var20_27.value;
                        continue;
                    }
lbl86:
                    // 1 sources

                    this.list.putAll(this.slist);
                }
                this.multisegmentNames.clear();
                this.slist.clear();
            }
            throw var15_28;
        }
    }

    public int size() {
        return this.list.size();
    }

    public String get(String string) {
        Object v2 = this.list.get(string.trim().toLowerCase(Locale.ENGLISH));
        String string2 = v2 instanceof MultiValue ? ((MultiValue)v2).value : (v2 instanceof Value ? ((Value)v2).value : (String)v2);
        return string2;
    }

    public void set(String string, String string2) {
        if (string == null && string2 != null && string2.equals("DONE")) {
            if (decodeParameters && this.multisegmentNames.size() > 0) {
                try {
                    this.combineMultisegmentNames(true);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return;
        }
        string = string.trim().toLowerCase(Locale.ENGLISH);
        if (decodeParameters) {
            try {
                this.putEncodedName(string, string2);
            }
            catch (ParseException parseException) {
                this.list.put(string, string2);
            }
        } else {
            this.list.put(string, string2);
        }
    }

    public void set(String string, String string2, String string3) {
        if (encodeParameters) {
            Value value = ParameterList.encodeValue(string2, string3);
            if (value != null) {
                this.list.put(string.trim().toLowerCase(Locale.ENGLISH), value);
            } else {
                this.set(string, string2);
            }
        } else {
            this.set(string, string2);
        }
    }

    public void remove(String string) {
        this.list.remove(string.trim().toLowerCase(Locale.ENGLISH));
    }

    public Enumeration getNames() {
        return new ParamEnum(this.list.keySet().iterator());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n2) {
        ToStringBuffer toStringBuffer = new ToStringBuffer(n2);
        Iterator iterator = this.list.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v2 = this.list.get(string);
            if (v2 instanceof MultiValue) {
                MultiValue multiValue = (MultiValue)v2;
                String string2 = string + "*";
                int n3 = 0;
                while (n3 < multiValue.size()) {
                    Object e2 = multiValue.get(n3);
                    if (e2 instanceof Value) {
                        toStringBuffer.addNV(string2 + n3 + "*", ((Value)e2).encodedValue);
                    } else {
                        toStringBuffer.addNV(string2 + n3, (String)e2);
                    }
                    ++n3;
                }
                continue;
            }
            if (v2 instanceof Value) {
                toStringBuffer.addNV(string + "*", ((Value)v2).encodedValue);
                continue;
            }
            toStringBuffer.addNV(string, (String)v2);
        }
        return toStringBuffer.toString();
    }

    private static String quote(String string) {
        return MimeUtility.quote(string, "()<>@,;:\\\"\t []/?=");
    }

    private static Value encodeValue(String string, String string2) {
        byte[] byArray;
        if (MimeUtility.checkAscii(string) == 1) {
            return null;
        }
        try {
            byArray = string.getBytes(MimeUtility.javaCharset(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length + string2.length() + 2);
        stringBuffer.append(string2).append("''");
        int n2 = 0;
        while (n2 < byArray.length) {
            char c2 = (char)(byArray[n2] & 0xFF);
            if (c2 <= ' ' || c2 >= '\u007f' || c2 == '*' || c2 == '\'' || c2 == '%' || "()<>@,;:\\\"\t []/?=".indexOf(c2) >= 0) {
                stringBuffer.append('%').append(hex[c2 >> 4]).append(hex[c2 & 0xF]);
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        Value value = new Value();
        value.charset = string2;
        value.value = string;
        value.encodedValue = stringBuffer.toString();
        return value;
    }

    private static Value decodeValue(String string) throws ParseException {
        Value value;
        block10: {
            value = new Value();
            value.encodedValue = string;
            value.value = string;
            try {
                int n2 = string.indexOf(39);
                if (n2 <= 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing charset in encoded value: " + string);
                    }
                    return value;
                }
                String string2 = string.substring(0, n2);
                int n3 = string.indexOf(39, n2 + 1);
                if (n3 < 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing language in encoded value: " + string);
                    }
                    return value;
                }
                String string3 = string.substring(n2 + 1, n3);
                string = string.substring(n3 + 1);
                value.charset = string2;
                value.value = ParameterList.decodeBytes(string, string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (decodeParametersStrict) {
                    throw new ParseException(numberFormatException.toString());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (decodeParametersStrict) {
                    throw new ParseException(unsupportedEncodingException.toString());
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (!decodeParametersStrict) break block10;
                throw new ParseException(stringIndexOutOfBoundsException.toString());
            }
        }
        return value;
    }

    private static String decodeBytes(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = new byte[string.length()];
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '%') {
                String string3 = string.substring(n2 + 1, n2 + 3);
                c2 = (char)Integer.parseInt(string3, 16);
                n2 += 2;
            }
            byArray[n3++] = (byte)c2;
            ++n2;
        }
        return new String(byArray, 0, n3, MimeUtility.javaCharset(string2));
    }

    static {
        try {
            String string = System.getProperty("mail.mime.encodeparameters");
            encodeParameters = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.decodeparameters");
            decodeParameters = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.decodeparameters.strict");
            decodeParametersStrict = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.applefilenames");
            applehack = string != null && string.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static class ToStringBuffer {
        private int used;
        private StringBuffer sb = new StringBuffer();

        public ToStringBuffer(int n2) {
            this.used = n2;
        }

        public void addNV(String string, String string2) {
            string2 = ParameterList.quote(string2);
            this.sb.append("; ");
            this.used += 2;
            int n2 = string.length() + string2.length() + 1;
            if (this.used + n2 > 76) {
                this.sb.append("\r\n\t");
                this.used = 8;
            }
            this.sb.append(string).append('=');
            this.used += string.length() + 1;
            if (this.used + string2.length() > 76) {
                String string3 = MimeUtility.fold(this.used, string2);
                this.sb.append(string3);
                int n3 = string3.lastIndexOf(10);
                this.used = n3 >= 0 ? (this.used += string3.length() - n3 - 1) : (this.used += string3.length());
            } else {
                this.sb.append(string2);
                this.used += string2.length();
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    private static class ParamEnum
    implements Enumeration {
        private Iterator it;

        ParamEnum(Iterator iterator) {
            this.it = iterator;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }

    private static class MultiValue
    extends ArrayList {
        String value;

        private MultiValue() {
        }
    }

    private static class Value {
        String value;
        String charset;
        String encodedValue;

        private Value() {
        }
    }
}

