/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.io;

import com.fr.zip4j.io.PartInputStream;
import com.fr.zip4j.unzip.UnzipEngine;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterInputStream
extends PartInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] oneByteBuff = new byte[1];
    private UnzipEngine unzipEngine;
    private long bytesWritten;
    private long uncompressedSize;

    public InflaterInputStream(RandomAccessFile randomAccessFile, long l2, long l3, UnzipEngine unzipEngine) {
        super(randomAccessFile, l2, l3, unzipEngine);
        this.inflater = new Inflater(true);
        this.buff = new byte[4096];
        this.unzipEngine = unzipEngine;
        this.bytesWritten = 0L;
        this.uncompressedSize = unzipEngine.getFileHeader().getUncompressedSize();
    }

    public int read() throws IOException {
        return this.read(this.oneByteBuff, 0, 1) == -1 ? -1 : this.oneByteBuff[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input buffer is null");
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input buffer is null");
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        try {
            int n4;
            if (this.bytesWritten >= this.uncompressedSize) {
                this.finishInflating();
                return -1;
            }
            while ((n4 = this.inflater.inflate(byArray, n2, n3)) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    this.finishInflating();
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
            }
            this.bytesWritten += (long)n4;
            return n4;
        }
        catch (DataFormatException dataFormatException) {
            String string = "Invalid ZLIB data format";
            if (dataFormatException.getMessage() != null) {
                string = dataFormatException.getMessage();
            }
            if (this.unzipEngine != null && this.unzipEngine.getLocalFileHeader().isEncrypted() && this.unzipEngine.getLocalFileHeader().getEncryptionMethod() == 0) {
                string = string + " - Wrong Password?";
            }
            throw new IOException(string);
        }
    }

    private void finishInflating() throws IOException {
        byte[] byArray = new byte[1024];
        while (super.read(byArray, 0, 1024) != -1) {
        }
        this.checkAndReadAESMacBytes();
    }

    private void fill() throws IOException {
        int n2 = super.read(this.buff, 0, this.buff.length);
        if (n2 == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inflater.setInput(this.buff, 0, n2);
    }

    public long skip(long l2) throws IOException {
        int n2;
        int n3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        int n4 = (int)Math.min(l2, Integer.MAX_VALUE);
        byte[] byArray = new byte[512];
        for (n2 = 0; n2 < n4; n2 += n3) {
            n3 = n4 - n2;
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            if ((n3 = this.read(byArray, 0, n3)) == -1) break;
        }
        return n2;
    }

    public void seek(long l2) throws IOException {
        super.seek(l2);
    }

    public int available() {
        return this.inflater.finished() ? 0 : 1;
    }

    public void close() throws IOException {
        this.inflater.end();
        super.close();
    }

    public UnzipEngine getUnzipEngine() {
        return super.getUnzipEngine();
    }
}

