/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.module;

import com.fr.base.FRContext;
import com.fr.file.ClusterConfigManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FUNC;
import com.fr.stable.CodeUtils;
import com.fr.stable.LicUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class CheckMultiLicThread
extends Thread {
    public static final int LIC_CHECK_PORT = 51377;
    private static ServerSocket server;
    private static CheckMultiLicThread licThread;

    public static CheckMultiLicThread getInstance() {
        if (licThread == null) {
            licThread = new CheckMultiLicThread();
        }
        return licThread;
    }

    private CheckMultiLicThread() {
    }

    public void startCheck() {
        if (server != null) {
            return;
        }
        licThread.start();
    }

    public void run() {
        this.checkMultiLic();
    }

    private void checkMultiLic() {
        String string = LicUtils.getLicAsStr();
        try {
            if (this.checkConfig(string)) {
                server = new ServerSocket();
                return;
            }
            this.multiLicAsServer(string);
        }
        catch (Exception exception) {
            try {
                this.multiLicAsClient(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private boolean checkConfig(String string) {
        return ClusterConfigManager.getInstance().isUseCluster() || server != null || StringUtils.isEmpty(string);
    }

    private void multiLicAsServer(String string) throws Exception {
        server = new ServerSocket(51377);
        Socket socket = server.accept();
        InputStream inputStream = socket.getInputStream();
        byte[] byArray = new byte[32768];
        inputStream.read(byArray);
        String string2 = new String(byArray, "UTF-8").trim();
        if (ComparatorUtils.equals(string2, CodeUtils.passwordEncode(string))) {
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("failure".getBytes());
            outputStream.close();
        }
        inputStream.close();
    }

    private static void releaseSocket() {
        CheckMultiLicThread.getInstance().stop();
        if (server == null || server.isClosed()) {
            return;
        }
        try {
            server.close();
            server = null;
            licThread = null;
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage());
        }
    }

    private void multiLicAsClient(String string) throws Exception {
        try {
            Socket socket = new Socket("127.0.0.1", 51377);
            server = new ServerSocket();
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(CodeUtils.passwordEncode(string).getBytes("UTF-8"));
            InputStream inputStream = socket.getInputStream();
            byte[] byArray = new byte[1024];
            inputStream.read(byArray);
            String string2 = new String(byArray, "UTF-8").trim();
            if (ComparatorUtils.equals(string2, "failure")) {
                FUNC.resetFunctions();
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                CheckMultiLicThread.releaseSocket();
            }
        });
    }
}

