/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.Style;
import com.fr.general.FRFont;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JEditorPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html2ImageUtils {
    private static final double DEFAULT_SCALE = 1.1;

    public static UNIT getHtmlHeight(String string, UNIT uNIT, Style style) {
        double d2 = uNIT.toPixD(96);
        StringBuffer stringBuffer = new StringBuffer("<div style='width:").append(d2).append("px;height:100%").append(Html2ImageUtils.getFontWrapStyle(style)).append(";'>");
        Dimension dimension = Html2ImageUtils.getHtmlContentDimension(string, stringBuffer);
        double d3 = d2 / dimension.getWidth();
        int n2 = (int)(dimension.getHeight() * 1.1);
        return FU.valueOfPix(n2, 96);
    }

    private static String getFontWrapStyle(Style style) {
        style = style == null ? Style.DEFAULT_STYLE : style;
        FRFont fRFont = style.getFRFont();
        double d2 = 96.0;
        double d3 = 72.0;
        return ";font-size:" + (double)fRFont.getSize() * d2 / d3 + "pt;font-family:" + fRFont.getFontName();
    }

    public static UNIT getHtmlWidth(String string, UNIT uNIT, Style style) {
        double d2 = uNIT.toPixD(96);
        StringBuffer stringBuffer = new StringBuffer("<div style='height:").append(d2).append("px;width:100%").append(Html2ImageUtils.getFontWrapStyle(style)).append(";'>");
        Dimension dimension = Html2ImageUtils.getHtmlContentDimension(string, stringBuffer);
        double d3 = d2 / dimension.getHeight();
        double d4 = (int)(dimension.getWidth() * d3);
        return FU.valueOfPix((int)d4, 96);
    }

    private static Dimension getHtmlContentDimension(String string, StringBuffer stringBuffer) {
        string = Html2ImageUtils.convertPt2Px(string);
        string = stringBuffer.append(string).append("</div>").toString();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        return jEditorPane.getPreferredSize();
    }

    public static BufferedImage createHTMLContentBufferedImage(String string, Rectangle rectangle, int n2, int n3, Style style) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(rectangle.width, rectangle.height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(n2, n3);
        Html2ImageUtils.paintOnJEditorPane(string, graphics2D, rectangle.width, style);
        graphics2D.translate(-n2, -n3);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void paintOnJEditorPane(String string, Graphics2D graphics2D, int n2, Style style) {
        if (n2 == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("<div style='width:").append(n2).append("px;height:100%").append(Html2ImageUtils.getFontWrapStyle(style)).append(";'>");
        string = Html2ImageUtils.convertPt2Px(string);
        string = string.replaceAll("<img src='", "<img src='file:///");
        string = stringBuffer.append(string).append("</div>").toString();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        Dimension dimension = jEditorPane.getPreferredSize();
        graphics2D.setPaint(Color.WHITE);
        double d2 = (double)n2 / ((double)dimension.width * 1.0);
        graphics2D.scale(d2, d2);
        jEditorPane.setSize(dimension);
        jEditorPane.paint(graphics2D);
    }

    public static String convertPt2Px(String string) {
        return Html2ImageUtils.convert(string, new Pt2Px());
    }

    public static String convertPx2Pt(String string) {
        return Html2ImageUtils.convert(string, new Px2Pt());
    }

    private static String convert(String string, PTX pTX) {
        boolean bl = false;
        int n2 = -1;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        char c2 = pTX.getSuffix();
        HashMap<Double, Double> hashMap = new HashMap<Double, Double>();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c3 = cArray[i2];
            switch (c3) {
                case '<': {
                    bl = true;
                    break;
                }
                case '>': {
                    bl = false;
                }
            }
            if (!bl) continue;
            if (c3 == c2) {
                n3 = Html2ImageUtils.checkSecondChar(i2, n2, cArray, n3, stringBuffer, string, pTX, hashMap);
                continue;
            }
            if (c3 != 'p') continue;
            n2 = i2;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private static int checkSecondChar(int n2, int n3, char[] cArray, int n4, StringBuffer stringBuffer, String string, PTX pTX, HashMap<Double, Double> hashMap) {
        if (n3 == -1 || n2 - n3 != 1) {
            return n4;
        }
        int n5 = -1;
        int n6 = Math.min(10, n3);
        int n7 = n3 - n6;
        for (int i2 = n3 - 1; i2 > n7; --i2) {
            if (cArray[i2] != ':' && cArray[i2] != ' ') continue;
            n5 = i2 + 1;
            break;
        }
        if (n5 != -1 && n3 != -1) {
            stringBuffer.append(string.substring(n4, n5)).append(pTX.getActualSize(string.substring(n5, n3), hashMap));
            n4 = n2 + 1;
        }
        return n4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Px2Pt
    implements PTX {
        private Px2Pt() {
        }

        @Override
        public char getSuffix() {
            return 'x';
        }

        @Override
        public String getActualSize(String string, HashMap<Double, Double> hashMap) {
            try {
                double d2;
                double d3 = Double.parseDouble(string.trim());
                if (hashMap.containsKey(d3)) {
                    d2 = hashMap.get(d3);
                } else {
                    d2 = d3 * 72.0 / 96.0;
                    hashMap.put(d3, d2);
                }
                return d2 + "pt";
            }
            catch (Exception exception) {
                return string + "px";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pt2Px
    implements PTX {
        private Pt2Px() {
        }

        @Override
        public char getSuffix() {
            return 't';
        }

        @Override
        public String getActualSize(String string, HashMap<Double, Double> hashMap) {
            try {
                double d2;
                double d3 = Double.parseDouble(string.trim());
                if (hashMap.containsKey(d3)) {
                    d2 = hashMap.get(d3);
                } else {
                    d2 = d3 * 96.0 / 72.0;
                    hashMap.put(d3, d2);
                }
                return d2 + "px";
            }
            catch (Exception exception) {
                return string + "pt";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PTX {
        public static final char T_SUFFIX = 't';
        public static final char X_SUFFIX = 'x';
        public static final String PT = "pt";
        public static final String PX = "px";

        public char getSuffix();

        public String getActualSize(String var1, HashMap<Double, Double> var2);
    }
}

