/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.FRContext;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.io.attr.ImageExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.report.ReportConfigManagerProvider;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;

public class ReportConfigManager
extends XMLFileManager
implements ReportConfigManagerProvider {
    private static ReportConfigManagerProvider configManager = null;
    private ReportExportAttr exportAttr = new ReportExportAttr();

    private static void envChanged() {
        configManager = null;
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        ReportConfigManager reportConfigManager = new ReportConfigManager();
        XMLTools.readInputStreamXML(reportConfigManager, inputStream);
        configManager = reportConfigManager;
        FRContext.getCurrentEnv().writeResource(configManager);
    }

    public static synchronized ReportConfigManagerProvider getInstance() {
        return ReportConfigManager.getProviderInstance();
    }

    public static synchronized ReportConfigManagerProvider getProviderInstance() {
        if (configManager == null) {
            if (ReportConfigManager.isClusterMember()) {
                return configManager;
            }
            configManager.readXMLFile();
        }
        return configManager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                configManager = new ReportConfigManager();
                RPC.registerSkeleton(configManager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                configManager = (ReportConfigManagerProvider)RPC.getProxy(ReportConfigManager.class, string);
                return true;
            }
        }
        configManager = new ReportConfigManager();
        return false;
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource(ReportConfigManager.getProviderInstance());
    }

    public String fileName() {
        return "reportconfig.xml";
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (xMLableReader.isChildNode() && ComparatorUtils.equals("ReportExportAttr", string)) {
            this.exportAttr = new ReportExportAttr();
            xMLableReader.readXMLObject(this.exportAttr);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ReportServerParameter");
        if (this.exportAttr != null) {
            this.exportAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public ReportExportAttr getExportAttr() {
        return this.exportAttr;
    }

    public void setExportAttr(ReportExportAttr reportExportAttr) {
        this.exportAttr = reportExportAttr;
    }

    public ImageExportAttr getImageExportAttr() {
        ImageExportAttr imageExportAttr = this.getExportAttr().getImageExportAttr();
        if (imageExportAttr == null) {
            this.getExportAttr().setImageExportAttr(new ImageExportAttr());
        }
        imageExportAttr = this.getExportAttr().getImageExportAttr();
        return imageExportAttr;
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ReportConfigManager.envChanged();
            }
        });
    }
}

