/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.DML;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.core.db.tableObject.AbstractTableObject;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.core.db.tableObject.TableObject;
import com.fr.data.dao.ResultSetExtractor;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.pool.DBCPConnectionPoolAttr;
import com.fr.general.DateUtils;
import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteInfo;
import com.fr.general.FRLogCleanAttr;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.RecordManager;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.record.DBRecordUtils;
import com.fr.record.ErrorRecord;
import com.fr.record.ExecuteRecord;
import com.fr.record.ExportRecord;
import com.fr.record.FSRecord;
import com.fr.record.JdbcTemplate;
import com.fr.record.PrintRecord;
import com.fr.record.RecordTables;
import com.fr.record.ScheduleRecord;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.fun.LogDBRecordProcessor;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DBRecordManager
implements RecordManager {
    private static Timer DB_RECORD_MANAGER_TIMER = null;
    private static JDBCDatabaseConnection databaseConnection;
    private JdbcTemplate jdbcTemplate;
    private static final int STATE_ERROR = -2;
    private static final int STATE_ON = 1;
    private int state = 1;
    private static DBRecordManager manager;
    private volatile Queue<Insert> queue = new ConcurrentLinkedQueue<Insert>();
    private DBThread thread;
    private int dayofweek = 7;
    private int dayofmouth = 30;
    private int hourofday = 24;
    private int secondofhour = 3600;
    private int thousand = 1000;
    private FRLogCleanAttr cleanAttr;

    public static synchronized RecordManager getInstance() {
        if (manager == null) {
            manager = new DBRecordManager();
        }
        return manager;
    }

    private DBRecordManager() {
        this.initThread();
    }

    private void initThread() {
        if (this.thread != null) {
            return;
        }
        this.state = 1;
        this.thread = new DBThread();
        this.thread.start();
    }

    private void init() throws Exception {
        Connection connection = null;
        try {
            connection = DBRecordManager.getDB().createConnection();
            RecordTables recordTables = new RecordTables();
            recordTables.generatorModuleTables(connection);
            recordTables.generateIndexs(connection);
            this.jdbcTemplate = new JdbcTemplate(DBRecordManager.getDB());
            this.initDelTraceTimer();
        }
        catch (Exception exception) {
            this.state = -2;
            throw exception;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public boolean isOK() {
        return this.state != -2;
    }

    public static synchronized JDBCDatabaseConnection getDB() {
        if (databaseConnection == null) {
            DBRecordManager.initLogDBConnection();
        }
        return databaseConnection;
    }

    private static void initLogDBConnection() {
        if (databaseConnection == null) {
            LogDBRecordProcessor logDBRecordProcessor = (LogDBRecordProcessor)ExtraClassManager.getInstance().getSingle("LogDBRecordProcessor");
            databaseConnection = logDBRecordProcessor != null && logDBRecordProcessor.isEnabled() ? DBRecordManager.getLogDBConnection(logDBRecordProcessor) : DBUtils.getEmbeddedDB("logdb", 5);
        }
    }

    private static JDBCDatabaseConnection getLogDBConnection(LogDBRecordProcessor logDBRecordProcessor) {
        JDBCDatabaseConnection jDBCDatabaseConnection = new JDBCDatabaseConnection(logDBRecordProcessor.driver(), logDBRecordProcessor.url(), logDBRecordProcessor.username(), logDBRecordProcessor.password());
        jDBCDatabaseConnection.setOriginalCharsetName(logDBRecordProcessor.originalCharset());
        jDBCDatabaseConnection.setNewCharsetName(logDBRecordProcessor.newCharset());
        DBCPConnectionPoolAttr dBCPConnectionPoolAttr = new DBCPConnectionPoolAttr();
        dBCPConnectionPoolAttr.setInitialSize(1);
        dBCPConnectionPoolAttr.setMaxActive(5);
        dBCPConnectionPoolAttr.setMaxWait(5000);
        jDBCDatabaseConnection.setDbcpAttr(dBCPConnectionPoolAttr);
        return jDBCDatabaseConnection;
    }

    private static synchronized void shutdownDB() throws Exception {
        Object object;
        if (manager != null) {
            object = DBRecordManager.manager.thread;
            if (object != null) {
                ((DBThread)object).end();
            }
            DBRecordManager.manager.thread = null;
        }
        try {
            if (DB_RECORD_MANAGER_TIMER != null) {
                DB_RECORD_MANAGER_TIMER.cancel();
            }
        }
        catch (Throwable throwable) {
            FRContext.getLogger().error("cancel timer-3 failed");
        }
        if (databaseConnection != null) {
            try {
                object = databaseConnection.createConnection();
                LogDBRecordProcessor logDBRecordProcessor = (LogDBRecordProcessor)ExtraClassManager.getInstance().getSingle("LogDBRecordProcessor");
                if (logDBRecordProcessor == null) {
                    object.createStatement().execute("shutdown");
                } else {
                    logDBRecordProcessor.showdown((Connection)object);
                }
            }
            finally {
                databaseConnection = null;
            }
        }
    }

    public void recordErrorInfo(String string, short s2, String string2, String string3, String string4) throws Exception {
        this.addToExecuteQueue(ErrorRecord.getInstance().createInsert(string, s2, string2, string3, string4, new Date()));
    }

    public void recordScheduleInfo(String string, short s2, String string2, String string3, String string4, String string5) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
        this.addToExecuteQueue(ScheduleRecord.getInstance().createInsert(string, s2, string2, string3, string4, simpleDateFormat.parse(simpleDateFormat.format(new Date())), string5));
    }

    public void recordFSInfo(String string, String string2, String string3) throws Exception {
        this.addToExecuteQueue(FSRecord.getInstance().createInsert(string, string2, string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToExecuteQueue(Insert insert) {
        if (insert != null && this.thread != null) {
            this.queue.add(insert);
            DBThread dBThread = this.thread;
            synchronized (dBThread) {
                this.thread.notify();
            }
        }
    }

    public void recordExecuteInfo(String string, DeclareRecordType declareRecordType, ExecuteInfo executeInfo) throws Exception {
        this.addToExecuteQueue(ExecuteRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), executeInfo));
    }

    public void recordAccessNoExecuteInfo(String string, DeclareRecordType declareRecordType, ExecuteInfo executeInfo) throws Exception {
        this.addToExecuteQueue(ExecuteRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), executeInfo));
    }

    public void recordExportInfo(String string, String string2, DeclareRecordType declareRecordType, long l2, String string3) throws Exception {
        ExecuteInfo executeInfo = new ExecuteInfo(string2, l2, string3);
        this.addToExecuteQueue(ExportRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), executeInfo));
    }

    public void recordPrintInfo(String string, String string2, DeclareRecordType declareRecordType) throws Exception {
        this.addToExecuteQueue(PrintRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), string2));
    }

    private void executeInsert(Insert insert) throws Exception {
        if (insert != null) {
            this.jdbcTemplate.execute(insert);
        }
    }

    private void initDelTraceTimer() {
        this.cleanAttr = ConfigManager.getProviderInstance().getLogCleanAttr();
        if (this.cleanAttr == null) {
            this.cleanAttr = new FRLogCleanAttr(System.currentTimeMillis());
            try {
                ConfigManager.getProviderInstance().setLogCleanAttr(this.cleanAttr);
                FRContext.getCurrentEnv().writeResource(ConfigManager.getProviderInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        DB_RECORD_MANAGER_TIMER = new Timer();
        long l2 = System.currentTimeMillis();
        long l3 = (long)this.dayofweek * (long)this.hourofday * (long)this.secondofhour * (long)this.thousand;
        long l4 = (long)this.cleanAttr.getFrLogCleanRate() * (long)this.hourofday * (long)this.secondofhour * (long)this.thousand;
        long l5 = (long)this.hourofday * (long)this.secondofhour * (long)this.thousand;
        long l6 = (l2 / l3 + 1L) * l3;
        long l7 = l2;
        DB_RECORD_MANAGER_TIMER.schedule((TimerTask)new DelTimerTask(), new Date(l6), l3);
        DB_RECORD_MANAGER_TIMER.schedule((TimerTask)new DelTimerTask4Log(), new Date(l7), l4);
        DB_RECORD_MANAGER_TIMER.schedule((TimerTask)new FunctionCollectorTimerTask(), new Date(l7), l5);
    }

    private static Where createWhere(Date date, Date date2) {
        Where where = new Where();
        where.addColumn("logtime", 93, 3, date);
        where.addColumn("logtime", 93, 4, date2);
        where.addColumn("func", 12, 1, "");
        return where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFunctionPointMsg(String string, String string2, Date date, Date date2) {
        if (new File(StableUtils.pathJoin(string2, string)).exists()) {
            return;
        }
        Where where = DBRecordManager.createWhere(date, date2);
        Select select = null;
        Connection connection = null;
        try {
            connection = DBRecordManager.getDB().createConnection();
            this.makesureTableExist(new AbstractTableObject(){

                protected void initColumns() {
                    this.addColumn("func", 12, new ColumnSize(255));
                    this.addColumn("logtime", 93, new ColumnSize());
                }

                public Table getTable() {
                    return new Table("fr_functionrecord");
                }
            }, connection);
            select = new Select(new Table("fr_functionrecord"), where, DialectFactory.generateDialect(connection));
        }
        catch (Exception exception) {
            FRLogger.getLogger().info("generate dialect failed!");
        }
        finally {
            DBUtils.closeConnection(connection);
        }
        if (select == null) {
            FRLogger.getLogger().info("create select sql failed");
        }
        try {
            final StringBuffer stringBuffer = new StringBuffer();
            this.jdbcTemplate.executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        String string = resultSet.getString("func");
                        String string2 = GeneralUtils.objectToString(resultSet.getTimestamp("logtime"));
                        Iterator iterator = new JSONObject(string).keys();
                        while (iterator.hasNext()) {
                            stringBuffer.append(iterator.next()).append(",").append(string2).append(System.getProperty("line.separator"));
                        }
                    }
                    return stringBuffer;
                }
            });
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            IOUtils.copy(byteArrayInputStream, string, new File(string2));
        }
        catch (Exception exception) {
            FRLogger.getLogger().info("collect product info of func failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTempUsageMsg(String string, String string2, Date date, Date date2) {
        block8: {
            if (new File(StableUtils.pathJoin(string2, string)).exists()) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            String[] stringArray = new String[]{"fr_exerecord", "fr_exprecord", "fr_ptrecord"};
            try {
                connection = DBRecordManager.getDB().createConnection();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    Select select = this.getSingleSelectSQL(stringArray[i2], date, date2, connection);
                    if (select == null) continue;
                    preparedStatement = select.createPreparedStatement(connection);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString("tname");
                        String string4 = resultSet.getString("username");
                        int n2 = resultSet.getInt("type");
                        String string5 = GeneralUtils.objectToString(resultSet.getTimestamp("logtime"));
                        stringBuffer.append(string3).append(",").append(string4).append(",").append(n2).append(",").append(string5).append(System.getProperty("line.separator"));
                    }
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
                IOUtils.copy(byteArrayInputStream, string, new File(string2));
                DBUtils.closeResultSet(resultSet);
            }
            catch (Exception exception) {
                FRLogger.getLogger().info("collect product info of tpl failed!");
                break block8;
            }
            finally {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(preparedStatement);
                DBUtils.closeConnection(connection);
            }
            DBUtils.closeStatement(preparedStatement);
            DBUtils.closeConnection(connection);
        }
    }

    private Select getSingleSelectSQL(String string, Date date, Date date2, Connection connection) throws Exception {
        try {
            Where where = new Where();
            where.addColumn("logtime", 93, 3, date);
            where.addColumn("logtime", 93, 4, date2);
            Select select = new Select(new Table(string), where, DialectFactory.generateDialect(connection));
            select.addColumnName("tname");
            select.addColumnName("username");
            select.addColumnName("logtime");
            select.addColumnName("type");
            return select;
        }
        catch (Exception exception) {
            FRLogger.getLogger().info("generate select sql failed");
            return null;
        }
    }

    private void makesureTableExist(TableObject tableObject, Connection connection) {
        try {
            tableObject.createTable(connection);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    static {
        manager = null;
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                databaseConnection = null;
            }
        });
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStart() {
                if (manager != null) {
                    manager.initThread();
                }
            }

            public void onServletStop() {
                try {
                    DBRecordManager.shutdownDB();
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error("shutdown logdb failed" + throwable.getMessage());
                }
            }
        });
    }

    private class FunctionCollectorTimerTask
    extends TimerTask {
        private FunctionCollectorTimerTask() {
        }

        public void run() {
            Date date = DBRecordUtils.getOffsetMonth1st(0);
            Date date2 = DBRecordUtils.getOffsetMonth1st(-1);
            String string = DateUtils.getDate2Str("yyyyMM", date2);
            String string2 = StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), "product_improvement");
            String string3 = "funcmsg" + string + ".txt";
            String string4 = "tempmsg" + string + ".txt";
            DBRecordManager.this.exportFunctionPointMsg(string3, string2, date2, date);
            DBRecordManager.this.exportTempUsageMsg(string4, string2, date2, date);
        }
    }

    private class DelTimerTask4Log
    extends TimerTask {
        private DelTimerTask4Log() {
        }

        public void run() {
            if (!DBRecordManager.this.cleanAttr.isAutoClean()) {
                return;
            }
            LogDBRecordProcessor logDBRecordProcessor = (LogDBRecordProcessor)ExtraClassManager.getInstance().getSingle("LogDBRecordProcessor");
            if (logDBRecordProcessor != null && logDBRecordProcessor.isEnabled()) {
                return;
            }
            long l2 = (long)DBRecordManager.this.cleanAttr.getFrLogCleanRate() * (long)DBRecordManager.this.hourofday * (long)DBRecordManager.this.secondofhour * (long)DBRecordManager.this.thousand;
            if (DBRecordManager.this.cleanAttr.getLastCleanTime() > 0L && System.currentTimeMillis() - l2 < DBRecordManager.this.cleanAttr.getLastCleanTime()) {
                return;
            }
            DBRecordManager.this.cleanAttr.setLastCleanTime(System.currentTimeMillis());
            DBRecordUtils.cleanLogTables();
            ConfigManager.getProviderInstance().setLogCleanAttr(DBRecordManager.this.cleanAttr);
            try {
                FRContext.getCurrentEnv().writeResource(ConfigManager.getProviderInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private class DelTimerTask
    extends TimerTask {
        private DelTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Where where = new Where();
            Date date = new Date(System.currentTimeMillis() - (long)DBRecordManager.this.dayofweek * (long)DBRecordManager.this.hourofday * (long)DBRecordManager.this.secondofhour * (long)DBRecordManager.this.thousand);
            Date date2 = new Date(System.currentTimeMillis() - (long)DBRecordManager.this.dayofmouth * (long)DBRecordManager.this.hourofday * (long)DBRecordManager.this.secondofhour * (long)DBRecordManager.this.thousand);
            where.addColumn("logtime", 93, 4, date);
            where.addColumn("logtime", 93, 2, date2);
            where.addColumn("trace", -1, 1, "");
            Connection connection = null;
            try {
                connection = DBRecordManager.getDB().createConnection();
                Update update = new Update(new Table("fr_errrecord"), where, DialectFactory.generateDialect(connection));
                update.addColumn("trace", -1, null);
                DBRecordManager.this.jdbcTemplate.execute(update);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Log_DelTimerTask action failed! : " + exception.getMessage(), exception);
            }
            finally {
                DBUtils.closeConnection(connection);
            }
        }
    }

    private class DBThread
    extends Thread {
        private volatile boolean running = true;

        public DBThread() {
            try {
                DBRecordManager.this.init();
            }
            catch (Exception exception) {
                DBRecordManager.this.state = -2;
                throw new RuntimeException(exception.getMessage());
            }
        }

        private void end() {
            this.running = false;
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running && DBRecordManager.this.state == 1 && manager != null) {
                if (DBRecordManager.this.queue.isEmpty()) {
                    DBThread dBThread = this;
                    synchronized (dBThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                while (!DBRecordManager.this.queue.isEmpty() && this.running) {
                    try {
                        manager.jdbcTemplate.execute((DML)DBRecordManager.this.queue.poll());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

