/*
 * Decompiled with CFR 0.152.
 */
package com.fr.print;

import com.fr.base.FRContext;
import com.fr.base.PaperSize;
import com.fr.general.ComparatorUtils;
import com.fr.io.TemplateWorkBookIO;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PaperSettingGetter;
import com.fr.page.PaperSettingProvider;
import com.fr.page.PrintableSet;
import com.fr.report.core.ReportUtils;
import com.fr.stable.ActorFactory;
import com.fr.stable.unit.INCH;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public class PrintUtils {
    private static final double INCH_SIZE = 72.0;
    private static final float INCH_SIZE_F = 72.0f;

    private PrintUtils() {
    }

    public static boolean printWorkBook(String string) {
        return PrintUtils.printWorkBook(string, false);
    }

    public static boolean printWorkBook(String string, boolean bl) {
        return PrintUtils.printWorkBook(string, new HashMap(), bl);
    }

    public static boolean printWorkBook(String string, Map map, boolean bl) {
        try {
            TemplateWorkBook templateWorkBook = TemplateWorkBookIO.readTemplateWorkBook(FRContext.getCurrentEnv(), string);
            ResultWorkBook resultWorkBook = templateWorkBook.execute(map, ActorFactory.getActor("page"));
            PrintUtils.print(resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(templateWorkBook)).traverse4Export(), bl);
            return true;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return false;
        }
    }

    public static void print(PrintableSet printableSet, boolean bl) throws PrinterException {
        PrintUtils.print(printableSet, bl, null);
    }

    public static void print(PrintableSet printableSet) throws PrinterException {
        PrintUtils.print(printableSet, false, null);
    }

    public static void print(PrintableSet printableSet, boolean bl, String string) throws PrinterException {
        PrintUtils.print(printableSet, bl, string, 0);
    }

    public static void print(PrintableSet printableSet, boolean bl, String string, int n2) throws PrinterException {
        Object object;
        Object object2 = null;
        if (string != null) {
            object = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
            for (int i2 = 0; i2 < ((PrintService[])object).length; ++i2) {
                if (!ComparatorUtils.equals(string, object[i2].getName())) continue;
                object2 = object[i2];
                break;
            }
        }
        if (object2 == null) {
            object2 = PrintServiceLookup.lookupDefaultPrintService();
        }
        object = PrinterJob.getPrinterJob();
        if (object2 != null) {
            ((PrinterJob)object).setPrintService((PrintService)object2);
        }
        if (printableSet.size() == 0) {
            return;
        }
        PrintUtils.getPageablePrintBook((PrinterJob)object, printableSet, (PrintService)object2, bl, n2);
        ((PrinterJob)object).print();
    }

    public static void getPageablePrintBook(PrinterJob printerJob, PrintableSet printableSet, PrintService printService, boolean bl, int n2) {
        boolean bl2 = false;
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printerJob.getPrintService().getDefaultAttributeValue(MediaPrintableArea.class);
        INCH iNCH = new INCH(0.0f);
        INCH iNCH2 = new INCH(0.0f);
        PageFormat pageFormat = printerJob.defaultPage();
        for (int i2 = 0; i2 < printableSet.size(); ++i2) {
            Printable printable = printableSet.getPrintable(i2);
            if (!(printable instanceof PaperSettingGetter)) continue;
            PageFormat pageFormat2 = ((PaperSettingGetter)((Object)printable)).getPaperSetting().modifyPageFormat(printerJob.defaultPage(), iNCH, iNCH2);
            if (i2 == 0) {
                pageFormat = pageFormat2;
                continue;
            }
            if (pageFormat.getOrientation() == pageFormat2.getOrientation()) continue;
            bl2 = true;
            break;
        }
        Book book = new Book();
        if (bl2) {
            PrintUtils.printDifSetSheet(printerJob, printableSet, bl, n2, iNCH, iNCH2, book);
        } else {
            PrintUtils.printSameSetSheet(printerJob, printableSet, printService, bl, n2, iNCH, iNCH2, book);
        }
        printerJob.setPageable(book);
    }

    private static void printDifSetSheet(PrinterJob printerJob, PrintableSet printableSet, boolean bl, int n2, INCH iNCH, INCH iNCH2, Book book) {
        Printable printable;
        boolean bl2;
        if (bl && !(bl2 = printerJob.printDialog())) {
            return;
        }
        PageFormat pageFormat = printerJob.defaultPage();
        int n3 = 0;
        for (int i2 = 0; i2 < printableSet.size() && (printable = printableSet.getPrintable(i2)) != null; ++i2) {
            if (n3 < n2) {
                ++n3;
                continue;
            }
            if (printable instanceof PaperSettingGetter) {
                pageFormat = ((PaperSettingGetter)((Object)printable)).getPaperSetting().modifyPageFormat(pageFormat, iNCH, iNCH2);
            }
            pageFormat = printerJob.validatePage(pageFormat);
            book.append(printable, pageFormat);
        }
    }

    private static void printSameSetSheet(PrinterJob printerJob, PrintableSet printableSet, PrintService printService, boolean bl, int n2, INCH iNCH, INCH iNCH2, Book book) {
        Printable printable;
        int n3;
        Printable printable2 = printableSet.getPrintable(0);
        PaperSettingProvider paperSettingProvider = null;
        PageFormat pageFormat = printerJob.defaultPage();
        PrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (printable2 instanceof PaperSettingGetter) {
            paperSettingProvider = ((PaperSettingGetter)((Object)printable2)).getPaperSetting();
            pageFormat = paperSettingProvider.modifyPageFormat(pageFormat, iNCH, iNCH2);
            printRequestAttributeSet = PrintUtils.getPaperAttribute(printRequestAttributeSet, paperSettingProvider.getPaperSize(), paperSettingProvider);
        }
        if (pageFormat.getOrientation() == 0) {
            printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        } else {
            printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        }
        if (bl && (n3 = printerJob.printDialog(printRequestAttributeSet)) == 0) {
            return;
        }
        n3 = 0;
        PageFormat pageFormat2 = PrintUtils.getPageFormat(printRequestAttributeSet, printService, printerJob);
        pageFormat2.setPaper(pageFormat.getPaper());
        pageFormat2 = printerJob.validatePage(pageFormat2);
        for (int i2 = 0; i2 < printableSet.size() && (printable = printableSet.getPrintable(i2)) != null; ++i2) {
            if (n3 < n2) {
                ++n3;
                continue;
            }
            book.append(printable, pageFormat2);
        }
    }

    private static PrintRequestAttributeSet getPaperAttribute(PrintRequestAttributeSet printRequestAttributeSet, PaperSize paperSize, PaperSettingProvider paperSettingProvider) {
        float f2 = paperSize.getWidth().toMMValue4Scale2();
        float f3 = paperSize.getHeight().toMMValue4Scale2();
        float f4 = paperSettingProvider.getMargin().getLeft().toMMValue4Scale2();
        f4 = f4 <= 1.0f ? 1.0f : f4;
        float f5 = paperSettingProvider.getMargin().getRight().toMMValue4Scale2();
        float f6 = paperSettingProvider.getMargin().getTop().toMMValue4Scale2();
        f6 = f6 <= 1.0f ? 1.0f : f6;
        float f7 = paperSettingProvider.getMargin().getBottom().toMMValue4Scale2();
        float f8 = f2 - f4 - f5;
        f8 = f8 <= 1.0f ? 1.0f : f8;
        float f9 = f3 - f6 - f7;
        float f10 = f9 = f9 <= 1.0f ? 1.0f : f9;
        if (MediaSize.findMedia(f2, f3, 1000) != null) {
            printRequestAttributeSet.add(MediaSize.findMedia(f2, f3, 1000));
        }
        printRequestAttributeSet.add(new MediaPrintableArea(f4, f6, f8, f9, 1000));
        return printRequestAttributeSet;
    }

    private static PageFormat getPageFormat(PrintRequestAttributeSet printRequestAttributeSet, PrintService printService, PrinterJob printerJob) {
        MediaSize mediaSize;
        Object object;
        PageFormat pageFormat = printerJob.defaultPage();
        if (printService == null || printRequestAttributeSet == null) {
            return pageFormat;
        }
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (media == null && mediaPrintableArea == null && orientationRequested == null) {
            return pageFormat;
        }
        Paper paper = pageFormat.getPaper();
        if (mediaPrintableArea == null && media != null && printService.isAttributeCategorySupported(MediaPrintableArea.class) && (object = printService.getSupportedAttributeValues(MediaPrintableArea.class, null, printRequestAttributeSet)) instanceof MediaPrintableArea[] && ((MediaPrintableArea[])object).length > 0) {
            mediaPrintableArea = ((MediaPrintableArea[])object)[0];
        }
        if (media != null && printService.isAttributeValueSupported(media, null, printRequestAttributeSet) && media instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)(object = (MediaSizeName)media))) != null) {
            double d2 = 72.0;
            double d3 = (double)mediaSize.getX(25400) * d2;
            double d4 = (double)mediaSize.getY(25400) * d2;
            paper.setSize(d3, d4);
            if (mediaPrintableArea == null) {
                paper.setImageableArea(d2, d2, d3 - 2.0 * d2, d4 - 2.0 * d2);
            }
        }
        if (mediaPrintableArea != null && printService.isAttributeValueSupported(mediaPrintableArea, null, printRequestAttributeSet)) {
            object = mediaPrintableArea.getPrintableArea(25400);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                object[i2] = object[i2] * 72.0f;
            }
            paper.setImageableArea((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
        }
        PrintUtils.setOrientation(orientationRequested, printRequestAttributeSet, printService, pageFormat);
        pageFormat.setPaper(paper);
        pageFormat = printerJob.validatePage(pageFormat);
        return pageFormat;
    }

    private static void setOrientation(OrientationRequested orientationRequested, PrintRequestAttributeSet printRequestAttributeSet, PrintService printService, PageFormat pageFormat) {
        if (orientationRequested != null && printService.isAttributeValueSupported(orientationRequested, null, printRequestAttributeSet)) {
            int n2 = ComparatorUtils.equals(orientationRequested, OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (ComparatorUtils.equals(orientationRequested, OrientationRequested.LANDSCAPE) ? 0 : 1);
            pageFormat.setOrientation(n2);
        }
    }
}

