/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginConfigManagerProvider;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class PluginConfigManager
extends XMLFileManager
implements PluginConfigManagerProvider {
    private static final String XML_TAG = "PluginConfigManager";
    private static final String XML_TAG_PLUGIN_NODE = "p";
    private static final String XML_TAG_PLUGINS = "installedPlugins";
    private Set<String> pluginWrappers = new HashSet<String>();
    private static PluginConfigManagerProvider manager = null;

    public static synchronized PluginConfigManagerProvider getProviderInstance() {
        return PluginConfigManager.getProviderInstance(null);
    }

    public static synchronized PluginConfigManagerProvider getProviderInstance(InputStream inputStream) {
        if (manager == null) {
            if (PluginConfigManager.isClusterMember()) {
                return manager;
            }
            try {
                manager.readFromInputStream(inputStream);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return manager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                manager = new PluginConfigManager();
                RPC.registerSkeleton(manager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                manager = (PluginConfigManagerProvider)RPC.getProxy(PluginConfigManager.class, string);
                return true;
            }
        }
        manager = new PluginConfigManager();
        return false;
    }

    private static synchronized void envChanged() {
        manager = null;
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        XMLTools.readInputStreamXML(manager, inputStream);
    }

    public String[] getInstalledPluginWrapper() {
        return this.pluginWrappers.toArray(new String[this.pluginWrappers.size()]);
    }

    public void pushNewPlugin(Plugin plugin) {
        if (plugin != null) {
            this.pluginWrappers.add(plugin.getNodeName());
        }
    }

    public void removePlugin(Plugin plugin) {
        if (plugin != null) {
            this.pluginWrappers.remove(plugin.getNodeName());
        }
    }

    public void syncPluginConfig() {
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            return;
        }
        try {
            env.writeResource(manager, "plugins");
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(string = xMLableReader.getTagName(), XML_TAG_PLUGIN_NODE)) {
            this.pluginWrappers.add(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        this.writeInstalledPlugins(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private void writeInstalledPlugins(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG_PLUGINS);
        for (String string : this.pluginWrappers) {
            xMLPrintWriter.startTAG(XML_TAG_PLUGIN_NODE).textNode(string).end();
        }
        xMLPrintWriter.end();
    }

    public String fileName() {
        return "pluginconfig.xml";
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                PluginConfigManager.envChanged();
            }
        });
    }
}

