/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.jsqlparser.util.deparser;

import com.fr.general.jsqlparser.expression.Expression;
import com.fr.general.jsqlparser.expression.ExpressionVisitor;
import com.fr.general.jsqlparser.expression.operators.relational.ExpressionList;
import com.fr.general.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.fr.general.jsqlparser.schema.Column;
import com.fr.general.jsqlparser.statement.insert.Insert;
import com.fr.general.jsqlparser.statement.select.SelectVisitor;
import com.fr.general.jsqlparser.statement.select.SubSelect;
import java.util.Iterator;

public class InsertDeParser
implements ItemsListVisitor {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;
    protected SelectVisitor selectVisitor;

    public InsertDeParser() {
    }

    public InsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public void deParse(Insert insert) {
        this.buffer.append("INSERT INTO ");
        this.buffer.append(insert.getTable().getWholeTableName());
        if (insert.getColumns() != null) {
            this.buffer.append("(");
            Iterator iterator = insert.getColumns().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                this.buffer.append(column.getColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        insert.getItemsList().accept(this);
    }

    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept(this.expressionVisitor);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

