/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.web;

import com.fr.base.FRContext;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.Widget;
import com.fr.form.web.Location;
import com.fr.form.web.button.ExcelO;
import com.fr.form.web.button.page.First;
import com.fr.form.web.button.page.Last;
import com.fr.form.web.button.page.Next;
import com.fr.form.web.button.page.PageNavi;
import com.fr.form.web.button.page.Previous;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class FormToolBarManager
implements Serializable,
Cloneable,
XMLReadable {
    public static final String XML_TAG = "FormToolBarManager";
    private Location toolBarLocation;
    private ToolBar toolBar;

    public static FormToolBarManager createDefaultToolBar() {
        FormToolBarManager formToolBarManager = new FormToolBarManager();
        formToolBarManager.setToolBar(new ToolBar(new Widget[]{new First(), new Previous(), new PageNavi(), new Next(), new Last(), new ExcelO()}));
        return formToolBarManager;
    }

    public static FormToolBarManager createDefaultNorthToolBar() {
        FormToolBarManager formToolBarManager = new FormToolBarManager();
        formToolBarManager.setToolBar(new ToolBar(new Widget[]{new First(), new Previous(), new PageNavi(), new Next(), new Last(), new ExcelO()}));
        formToolBarManager.setToolBarLocation(Location.createTopEmbedLocation());
        return formToolBarManager;
    }

    public Location getToolBarLocation() {
        return this.toolBarLocation;
    }

    public void setToolBarLocation(Location location) {
        this.toolBarLocation = location;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        Location.writeXML(this.toolBarLocation, xMLPrintWriter);
        if (this.toolBar != null) {
            this.toolBar.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("ToolBar".equals(string)) {
                this.toolBar = new ToolBar();
                xMLableReader.readXMLObject(this.toolBar);
            } else if ("Location".equals(string)) {
                this.toolBarLocation = Location.readXML(xMLableReader);
            }
        }
    }

    public JSONObject toJSONConfig(Repository repository, Calculator calculator) {
        JSONObject jSONObject = new JSONObject();
        Location location = this.getToolBarLocation();
        if (location == null) {
            location = Location.createTopEmbedLocation();
        }
        if (location instanceof Location.Embed) {
            try {
                jSONObject.put("position", ((Location.Embed)location).getPosition() == 1 ? "north" : "south");
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        try {
            jSONObject.put("toolbarConf", this.getToolBar().createJSONConfig(repository, calculator, null));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public boolean isBottomPos() {
        Location location = this.getToolBarLocation();
        if (location instanceof Location.Embed) {
            return ((Location.Embed)location).getPosition() == 3;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        FormToolBarManager formToolBarManager = (FormToolBarManager)super.clone();
        if (this.toolBar != null) {
            formToolBarManager.toolBar = (ToolBar)this.toolBar.clone();
        }
        return formToolBarManager;
    }
}

