/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.BaseHTMLWriterUtils;
import java.awt.Dimension;

public class WidgetTitle
implements XMLable {
    public static final String XML_TAG = "WidgetTitle";
    public static final String TITLE_NAME_INDEX = "Title_";
    private Object text;
    private FRFont frFont;
    private int position = 0;
    private Background background;

    public WidgetTitle() {
        this.frFont = FRContext.getDefaultValues().getFRFont();
        this.text = Inter.getLocText("FR-Base_New-Title");
    }

    public WidgetTitle(Object object) {
        this.text = object;
    }

    public Object getTextObject() {
        return this.text;
    }

    public void setTextObject(Object object) {
        this.text = object;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public FRFont getFrFont() {
        return this.frFont;
    }

    public void setFrFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void dealFormula(Calculator calculator) {
        Utils.dealFormulaValue(this.text, calculator);
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        mOD_COLUMN_ROW.mod_object(this.text);
    }

    public void createJSONConfig(Repository repository, JSONObject jSONObject) throws JSONException {
        jSONObject.put("text", this.text);
        jSONObject.put("position", this.position);
        if (this.frFont != null) {
            jSONObject.put("frFont", this.frFont.toJSONObject());
        }
        if (this.background != null) {
            if (repository.getDevice().isMobile()) {
                jSONObject.put("widgetBackground", this.background.toJSONObject(repository, new Dimension(160, 160)));
            } else {
                jSONObject.put("widgetBackground", BaseHTMLWriterUtils.jsonBackground(this.background, repository));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WidgetTitle widgetTitle = (WidgetTitle)super.clone();
        if (this.frFont != null) {
            widgetTitle.frFont = (FRFont)this.frFont.clone();
        }
        if (this.text instanceof Formula) {
            widgetTitle.text = ((Formula)this.text).clone();
        }
        return widgetTitle;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("O".equals(string)) {
                this.text = GeneralXMLTools.readObject(xMLableReader);
            } else if ("FRFont".equals(xMLableReader.getTagName())) {
                this.frFont = BaseXMLUtils.readFRFont(xMLableReader);
            } else if ("Position".equals(string)) {
                this.position = xMLableReader.getAttrAsInt("pos", 0);
            } else if ("Background".equals(string)) {
                this.background = BaseXMLUtils.readBackground(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.text != null) {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.text);
        }
        if (this.getFrFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.getFrFont());
        }
        xMLPrintWriter.startTAG("Position").attr("pos", this.position).end();
        if (this.background != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof WidgetTitle && ComparatorUtils.equals(((WidgetTitle)object).getTextObject(), this.text) && ComparatorUtils.equals(((WidgetTitle)object).getFrFont(), this.frFont) && ((WidgetTitle)object).getPosition() == this.position && ComparatorUtils.equals(((WidgetTitle)object).getBackground(), this.background);
    }
}

