/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.Interactive;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.base.PrivilegeFilterRegister;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.PrivilegeFilterManager;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.js.WidgetName;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;

public class IframeEditor
extends FieldEditor
implements Interactive {
    public static final String XML_TAG = "Iframe";
    private String src;
    private ParameterProvider[] parameters;
    private boolean overflowx = true;
    private boolean overflowy = true;
    private String controlSrc;

    public IframeEditor() {
    }

    public IframeEditor(String string) {
        this.src = string;
    }

    public boolean isEditor() {
        return false;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String string) {
        this.src = string;
    }

    public boolean isOverflowx() {
        return this.overflowx;
    }

    public void setOverflowx(boolean bl) {
        this.overflowx = bl;
    }

    public boolean isOverflowy() {
        return this.overflowy;
    }

    public void setOverflowy(boolean bl) {
        this.overflowy = bl;
    }

    public boolean supportMobile() {
        return false;
    }

    public ParameterProvider[] getParameters() {
        return this.parameters == null ? new ParameterProvider[]{} : this.parameters;
    }

    public void setParameters(ParameterProvider[] parameterProviderArray) {
        this.parameters = parameterProviderArray;
    }

    public String getXType() {
        return "iframe";
    }

    public String[] supportedEvents() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute());
        calculator.pushNameSpace(parameterMapNameSpace);
        for (int i2 = 0; i2 < (this.parameters == null ? 0 : this.parameters.length); ++i2) {
            Object object;
            Object object2 = this.parameters[i2].getValue();
            if (object2 instanceof Formula) {
                object = ((Formula)object2).getContent();
                object2 = calculator.evalValue((String)object);
            }
            object = new JSONObject();
            if (object2 instanceof String) {
                object2 = CodeUtils.cjkEncode((String)object2);
                ((JSONObject)object).put(this.parameters[i2].getName(), object2);
            } else if (object2 instanceof FArray) {
                object2 = ((FArray)object2).cjkEncode();
                ((JSONObject)object).put(this.parameters[i2].getName(), object2);
            } else if (object2 instanceof WidgetName) {
                ((JSONObject)object).put("widgetName", ((WidgetName)object2).getName());
            } else {
                ((JSONObject)object).put(this.parameters[i2].getName(), object2);
            }
            jSONArray.put(object);
        }
        this.checkPrivilege(jSONArray, httpServletRequest);
        return jSONArray;
    }

    private JSONArray checkPrivilege(JSONArray jSONArray, HttpServletRequest httpServletRequest) {
        block5: {
            try {
                PrivilegeVote privilegeVote = PrivilegeFilterRegister.doPrivilegeFilter(httpServletRequest);
                if (privilegeVote == null || privilegeVote.isPermitted()) break block5;
                JSONObject jSONObject = new JSONObject();
                if (StringUtils.isNotEmpty(this.src) && this.isEmbeddedParaInside()) {
                    String string = Calendar.getInstance().getTime().toString().replaceAll(" ", "");
                    try {
                        jSONObject.put("fr_check_url", string);
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().error(jSONException.getMessage());
                    }
                    PrivilegeFilterManager.remoteWebPreview.put(string, string);
                }
                jSONArray.put(jSONObject);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage());
            }
        }
        return jSONArray;
    }

    private boolean isEmbeddedParaInside() {
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            if (!"reportlet".equals(this.parameters[i2].getName())) continue;
            return true;
        }
        return Utils.isEmbeddedParameter(this.src);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (StringUtils.isNotBlank(this.src)) {
            try {
                if (this.src.startsWith("/")) {
                    String string = repository.checkoutObject(this.src, "reportlet");
                    jSONObject.put("src", string);
                } else {
                    jSONObject.put("src", TemplateUtils.render(this.src));
                    jSONObject.put("controlAttr", this.controlSrc);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        jSONObject.put("showOverFlowX", this.isOverflowx());
        jSONObject.put("showOverFlowY", this.isOverflowy());
        return jSONObject;
    }

    public void mixinReturnData(HttpServletRequest httpServletRequest, Calculator calculator, JSONObject jSONObject) throws JSONException {
        try {
            if (this.src == null) {
                return;
            }
            String string = TemplateUtils.render(this.src);
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                Object object = this.parameters[i2].getValue();
                if (object instanceof Formula) {
                    String string2 = ((Formula)object).getContent();
                    object = calculator.evalValue(string2);
                }
                if (object instanceof String) {
                    object = CodeUtils.cjkEncode((String)object);
                } else if (object instanceof FArray) {
                    object = ((FArray)object).cjkEncode();
                }
                if (string.indexOf("?") == -1) {
                    string = string + "?";
                }
                string = string + (string.endsWith("?") ? "" : "&") + this.parameters[i2].getName() + "=" + Utils.objectToString(object);
            }
            jSONObject.put(this.widgetName != null ? this.widgetName.toUpperCase() : "", string);
            if (this.controlSrc == null) {
                this.controlSrc = string;
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals(XML_TAG)) {
                this.src = xMLableReader.getAttrAsString("src", null);
                this.setOverflowx(xMLableReader.getAttrAsBoolean("overflowx", true));
                this.setOverflowy(xMLableReader.getAttrAsBoolean("overflowy", true));
            } else if ("Parameters".equals(xMLableReader.getTagName())) {
                ParameterProvider[] parameterProviderArray = BaseXMLUtils.readParameters(xMLableReader);
                this.setParameters(parameterProviderArray);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.src)) {
            xMLPrintWriter.startTAG(XML_TAG).attr("src", this.src).attr("overflowx", this.isOverflowx()).attr("overflowy", this.isOverflowy()).end();
        }
        StableXMLUtils.writeParameters(xMLPrintWriter, this.getParameters());
    }

    public boolean equals(Object object) {
        return object instanceof IframeEditor && super.equals(object) && ComparatorUtils.equals(this.src, ((IframeEditor)object).src) && this.isOverflowx() == ((IframeEditor)object).isOverflowx() && this.isOverflowy() == ((IframeEditor)object).isOverflowy() && ComparatorUtils.equals(this.parameters, ((IframeEditor)object).parameters);
    }
}

