/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.main;

import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.js.FormHyperlinkProvider;
import com.fr.js.Hyperlink;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;

public class FormHyperlink
extends Hyperlink
implements FormHyperlinkProvider {
    private static final String CHART_SOURCENAME = "__CHARTSOURCENAME__";
    private static final String CHART_SIZE = "__CHARTSIZE__";
    protected String relateEditorName;
    private int type = 0;

    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public String getRelateEditorName() {
        return this.relateEditorName;
    }

    public void setRelateEditorName(String string) {
        this.relateEditorName = string;
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONObject(repository);
        jSONObject.put("related", this.relateEditorName);
        return jSONObject;
    }

    protected String getHyperlinkType() {
        return "widget";
    }

    protected JSONObject createPara(Repository repository) throws JSONException {
        return this.createJsonPara(repository, false);
    }

    protected String actionJS(Repository repository) {
        return this.getType() == 0 ? this.actionJS4Chart(repository) : this.actionJS4EC(repository);
    }

    protected String actionJS4Chart(Repository repository) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("chartID", this.relateEditorName);
        hashMap.put("titleAction", this.actionJS4Title(repository));
        try {
            hashMap.put("para", this.createPara(repository));
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error in Relate Chart Para");
        }
        try {
            return TemplateUtils.renderParameter4Tpl(TemplateUtils.readTemplate2String("com/fr/form/main/chartFormRelateJS.tpl", "UTF-8"), hashMap);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error in Form HyperlinkJS.");
            return "";
        }
    }

    protected String actionJS4EC(Repository repository) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_g().name_widgets['");
        stringBuffer.append(this.relateEditorName.toUpperCase());
        stringBuffer.append("'].gotoPage(1, ");
        stringBuffer.append(this.createJsonPara4EC(repository));
        stringBuffer.append(", 'T');");
        stringBuffer.append(this.actionJS4Title(repository));
        return stringBuffer.toString();
    }

    private StringBuffer actionJS4Title(Repository repository) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FR.recalculateElementTitle(");
        stringBuffer.append(this.createJsonPara4EC(repository));
        stringBuffer.append(", '");
        stringBuffer.append(("Title_" + this.relateEditorName.toUpperCase()).toUpperCase());
        stringBuffer.append("', 'T');");
        return stringBuffer;
    }

    private JSONObject createJsonPara4EC(Repository repository) {
        JSONObject jSONObject = this.createJsonPara(repository, true);
        jSONObject.remove(CHART_SOURCENAME);
        jSONObject.remove(CHART_SIZE);
        return jSONObject;
    }

    protected JSONObject createJsonPara(Repository repository, boolean bl) {
        JSONObject jSONObject = JSONObject.create();
        try {
            this.putExtendParameters(repository, jSONObject, bl);
            this.para2JSON(jSONObject, bl);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            Object var2_2 = null;
            if ("realateName".equals(xMLableReader.getTagName())) {
                this.setRelateEditorName(xMLableReader.getAttrAsString("realateValue", ""));
            } else if ("linkType".equals(xMLableReader.getTagName())) {
                this.setType(xMLableReader.getAttrAsInt("type", 0));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("realateName").attr("realateValue", this.relateEditorName).end();
        xMLPrintWriter.startTAG("linkType").attr("type", this.getType()).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof FormHyperlink && super.equals(object) && ComparatorUtils.equals(((FormHyperlink)object).getRelateEditorName(), this.relateEditorName);
    }
}

