/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.main;

import com.fr.base.FRContext;
import com.fr.form.event.Listener;
import com.fr.form.main.Form;
import com.fr.form.main.WidgetGatherAdapter;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.Interactive;
import com.fr.form.ui.NameWidget;
import com.fr.form.ui.Widget;
import com.fr.js.JavaScript;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.parser.Ambiguity;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.ArrayUtils;
import com.fr.stable.DeathCycleException;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.core.UUID;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowRange;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormConfig {
    private static FormConfig formConfig = new FormConfig();
    private static CalculatorKey DeathLoopGetWidgetValue = CalculatorKey.createKey("DeathLoopGetWidgetValue");

    private FormConfig() {
    }

    public static FormConfig getInstance() {
        return formConfig;
    }

    public JSONObject dealWithWidgetData(HttpServletRequest httpServletRequest, Form form, JSONArray jSONArray, Calculator calculator) throws JSONException {
        CalculatorMap<String, Widget> calculatorMap = CalculatorMap.createEmptyMap();
        ArrayList<Interactive> arrayList = new ArrayList<Interactive>();
        ArrayList<Widget> arrayList2 = new ArrayList<Widget>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            String string = (String)jSONArray.get(i2);
            Widget widget = form.getWidgetByName(string);
            if (widget == null) continue;
            this.traversalFormWidget(widget, calculatorMap, arrayList, arrayList2);
        }
        return this.dealWithWidgetData(httpServletRequest, calculatorMap, arrayList, calculator, arrayList2);
    }

    public JSONObject dealWithWidgetData(HttpServletRequest httpServletRequest, Widget widget, Calculator calculator) throws JSONException {
        CalculatorMap<String, Widget> calculatorMap = CalculatorMap.createEmptyMap();
        ArrayList<Interactive> arrayList = new ArrayList<Interactive>();
        ArrayList<Widget> arrayList2 = new ArrayList<Widget>();
        this.traversalFormWidget(widget, calculatorMap, arrayList, arrayList2);
        return this.dealWithWidgetData(httpServletRequest, calculatorMap, arrayList, calculator, arrayList2);
    }

    private void traversalFormWidget(Widget widget, final Map<String, Widget> map, final List<Interactive> list, final List<Widget> list2) {
        Form.traversalFormWidget(widget, new WidgetGatherAdapter(){

            public boolean dealWithAllCards() {
                return true;
            }

            public void dealWith(Widget widget) {
                Widget widget2;
                if (widget instanceof DataControl) {
                    if (StringUtils.isEmpty(widget.getWidgetName())) {
                        widget.setWidgetName(UUID.randomUUID().toString().substring(0, 8));
                    }
                    map.put(widget.getWidgetName(), widget);
                } else if (widget instanceof Interactive) {
                    list.add((Interactive)((Object)widget));
                } else if (widget instanceof NameWidget && (widget2 = ((NameWidget)widget).createWidget()) instanceof DataControl) {
                    map.put(widget2.getWidgetName(), widget2);
                }
                FormConfig.this.lookupWidgetEventDependence(widget, list2);
            }
        });
    }

    private void lookupWidgetEventDependence(Widget widget, List<Widget> list) {
        int n2 = widget.getListenerSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaScript javaScript;
            Listener listener = widget.getListener(i2);
            if (listener == null || !ArrayUtils.isNotEmpty((javaScript = listener.getAction()).getParameters())) continue;
            list.add(widget);
            break;
        }
    }

    private JSONObject dealWithWidgetData(HttpServletRequest httpServletRequest, Map<String, Widget> map, List<Interactive> list, Calculator calculator, List<Widget> list2) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        JSONObject jSONObject2 = JSONObject.create();
        WidgetValueNameSpace widgetValueNameSpace = new WidgetValueNameSpace(jSONObject2);
        calculator.pushNameSpace(widgetValueNameSpace);
        calculator.setAttribute(DeathLoopGetWidgetValue, new LinkedList());
        for (Map.Entry<String, Widget> object : map.entrySet()) {
            Widget widget = object.getValue();
            this.setWidgetValue(widget, map, calculator, jSONObject, jSONObject2);
        }
        for (Widget widget : list2) {
            this.calWidgetEventPara(calculator, widget);
        }
        for (Interactive interactive : list) {
            interactive.mixinReturnData(httpServletRequest, calculator, jSONObject2);
        }
        calculator.removeNameSpace(widgetValueNameSpace);
        return jSONObject2;
    }

    private void calWidgetEventPara(Calculator calculator, Widget widget) {
        int n2 = widget.getListenerSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            ParameterProvider[] parameterProviderArray;
            Listener listener = widget.getListener(i2);
            if (listener == null) continue;
            JavaScript javaScript = listener.getAction();
            for (ParameterProvider parameterProvider : parameterProviderArray = javaScript.getParameters()) {
                Object object = parameterProvider.getValue();
                if (!(object instanceof FormulaProvider)) continue;
                this.upateFormulaParaValue(calculator, parameterProvider, object);
            }
        }
    }

    private void upateFormulaParaValue(Calculator calculator, ParameterProvider parameterProvider, Object object) {
        try {
            object = calculator.eval((FormulaProvider)object);
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (object != null && object != Primitive.NULL) {
            parameterProvider.setValue(object);
        }
    }

    private void setWidgetValue(Widget widget, Map map, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) throws JSONException {
        if (jSONObject2.has(widget.getWidgetName().toUpperCase())) {
            return;
        }
        List list = (List)calculator.getAttribute(DeathLoopGetWidgetValue);
        if (list.contains(widget)) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(((Widget)list.get(i2)).getWidgetName());
                stringBuffer.append("->");
            }
            stringBuffer.append(widget.getWidgetName());
            FRContext.getLogger().error("Death cycle exists at calculating widgets:" + stringBuffer, new DeathCycleException(widget.getWidgetName()));
            return;
        }
        list.add(widget);
        String[] stringArray = ((DataControl)((Object)widget)).dependence(calculator);
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string;
            Widget widget2;
            if (stringArray[i3].length() <= 1 || (widget2 = (Widget)map.get(string = stringArray[i3].charAt(0) == '$' ? stringArray[i3].substring(1, stringArray[i3].length()) : stringArray[i3])) == null) continue;
            this.setWidgetValue(widget2, map, calculator, jSONObject, jSONObject2);
        }
        ((DataControl)((Object)widget)).createValueResult((DataControl)((Object)widget), calculator, jSONObject2, jSONObject);
        list.remove(widget);
    }

    public static class WidgetValueNameSpace
    extends AbstractNameSpace {
        private JSONObject result;

        public WidgetValueNameSpace(JSONObject jSONObject) {
            this.result = jSONObject;
        }

        public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
            if (this.result != null && this.result.length() > 0 && (object instanceof ColumnRowRange || object instanceof Ambiguity || object instanceof String)) {
                String string = object.toString().toUpperCase();
                if (string.length() == 0) {
                    return null;
                }
                if (string.charAt(0) == '$') {
                    string = string.substring(1, string.length());
                }
                if (this.result.has(string)) {
                    try {
                        Object object2 = this.result.get(string);
                        if (object2 instanceof JSONObject) {
                            return ((JSONObject)object2).get("value");
                        }
                        return object2;
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                    }
                }
            }
            return null;
        }
    }
}

