/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.RPCClient;
import com.fr.cluster.rpc.RPCUtil;
import com.fr.cluster.rpc.Result;
import com.fr.cluster.rpc.SocketClient;
import com.fr.cluster.rpc.annotation.CachedMethod;
import com.fr.cluster.rpc.annotation.InvalidAllCaches;
import com.fr.cluster.rpc.annotation.InvalidCache;
import com.fr.cluster.rpc.annotation.SynchronizedMethod;
import com.fr.cluster.rpc.cache.Accelerator;
import com.fr.cluster.rpc.cache.SkeletonPipe;
import com.fr.cluster.rpc.exception.CacheUnavailableException;
import com.fr.cluster.rpc.exception.SkeletonIsNullException;
import com.fr.general.FRLogger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SkeletonLocalization
extends Accelerator<Serializable, Object> {
    private Class skeletonClass;
    private RPCClient RPCClient;
    private ArrayList<String> whiteList;
    private static Long ID = -999L;

    public Class getSkeletonClass() {
        return this.skeletonClass;
    }

    public RPCClient getRPCClient() {
        return this.RPCClient;
    }

    private ArrayList<String> getCachedAnnotationMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Method[] methodArray;
            Class clazz = this.getSkeletonClass();
            for (Method method : methodArray = clazz.getMethods()) {
                Boolean bl = method.isAnnotationPresent(CachedMethod.class) || method.isAnnotationPresent(SynchronizedMethod.class) || method.isAnnotationPresent(InvalidCache.class) || method.isAnnotationPresent(InvalidAllCaches.class);
                if (!bl.booleanValue()) continue;
                arrayList.add(method.getName());
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return arrayList;
    }

    public SkeletonLocalization(RPCClient rPCClient, ArrayList<String> arrayList) {
        this(rPCClient, arrayList, 2048L, 0);
    }

    public SkeletonLocalization(RPCClient rPCClient, ArrayList<String> arrayList, Long l2, int n2) {
        super(n2, l2);
        this.RPCClient = rPCClient;
        this.whiteList = arrayList;
        try {
            this.skeletonClass = Class.forName(RPCUtil.decodeClassName(rPCClient.getClassName()));
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        this.whiteList.addAll(this.getCachedAnnotationMethods());
    }

    public boolean isSupport() {
        return this.supportLocalization();
    }

    public boolean isAvailable(Method method, Object[] objectArray) throws Throwable {
        if (!this.isAllow(method)) {
            return false;
        }
        Serializable serializable = this.fetchIdentifier(objectArray);
        if (this.isSupport()) {
            if (!this.canRead(serializable)) {
                try {
                    Object object = this.fetchSkeleton(serializable);
                    this.cache(serializable, object);
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
                return this.canRead(serializable);
            }
            return true;
        }
        return false;
    }

    private boolean isAllow(Method method) {
        return this.whiteList.contains(method.getName());
    }

    public void subsequentProcess(Method method, Object[] objectArray) {
    }

    public Object fetch(Method method, Object[] objectArray) throws CacheUnavailableException, SkeletonIsNullException {
        if (!this.isAllow(method)) {
            return null;
        }
        Serializable serializable = this.fetchIdentifier(objectArray);
        Object v2 = this.read(serializable);
        if (v2 == null) {
            throw new SkeletonIsNullException("remote object localization is vacancy,so need to provoke the remote object");
        }
        try {
            method.setAccessible(true);
            return method.invoke(v2, objectArray);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }

    protected Serializable fetchIdentifier(Object[] objectArray) {
        return ID;
    }

    protected Object fetchSkeleton(Serializable serializable) throws Throwable {
        SocketClient socketClient = this.RPCClient.perceive(SkeletonPipe.class.getMethod("fetchSkeleton", Serializable.class), new Object[]{serializable});
        return ((Result)this.RPCClient.readResult(socketClient)).getReturnValue(SkeletonPipe.class.getMethod("fetchSkeleton", Serializable.class));
    }

    private boolean supportLocalization() {
        Class<?>[] classArray = this.skeletonClass.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (RPCUtil.equalsTool(classArray[i2], SkeletonPipe.class)) {
                return true;
            }
            Class<?>[] classArray2 = classArray[i2].getInterfaces();
            for (int i3 = 0; i3 < classArray2.length; ++i3) {
                if (!RPCUtil.equalsTool(classArray2[i3], SkeletonPipe.class)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isEquals(Serializable serializable, Object object) {
        return false;
    }
}

