/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrAreaSeries;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBarSeries;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLineSeries;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartCustomRendererType;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.SimpleResult;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.data.condition.AbstractCondition;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class CustomAttr
extends ConditionAttr {
    private static final long serialVersionUID = 1257022581265772235L;
    public static final String XML_TAG = "CustomAttr";
    private ChartCustomRendererType renderer = ChartCustomRendererType.BAR_RENDERER;
    private ChartCustomRendererType useRenderer = ChartCustomRendererType.BAR_RENDERER;

    public CustomAttr() {
    }

    public CustomAttr(int n2) {
        this.setRenderer(n2);
    }

    public CustomAttr(ChartCustomRendererType chartCustomRendererType) {
        this.setRenderer(chartCustomRendererType);
    }

    public void setRenderer(int n2) {
        this.renderer = ChartCustomRendererType.parse(n2);
    }

    public void setRenderer(ChartCustomRendererType chartCustomRendererType) {
        this.renderer = chartCustomRendererType;
        this.useRenderer = chartCustomRendererType;
    }

    public ChartCustomRendererType getUseRenderer() {
        return this.useRenderer;
    }

    public void setUseRenderer(ChartCustomRendererType chartCustomRendererType) {
        this.useRenderer = chartCustomRendererType;
    }

    public ChartCustomRendererType getRenderer() {
        return this.renderer;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ctattr").attr("renderer", this.renderer.getRendererType()).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ((string = xMLableReader.getTagName()).equals("customattr") || string.equals("ctattr"))) {
            String string2;
            this.setRenderer(ChartCustomRendererType.parse(xMLableReader.getAttrAsInt("renderer", ChartCustomRendererType.BAR_RENDERER.getRendererType())));
            if (this.renderer == ChartCustomRendererType.LINE_STACK) {
                this.setRenderer(ChartCustomRendererType.LINE_RENDERER);
            }
            if ((string2 = xMLableReader.getAttrAsString("axisPosition", null)) != null) {
                this.addDataSeriesCondition(new AttrAxisPosition(string2));
            }
        }
    }

    public String getConditionAttrType() {
        return XML_TAG;
    }

    public Object clone() throws CloneNotSupportedException {
        CustomAttr customAttr = (CustomAttr)super.clone();
        customAttr.setRenderer(this.getRenderer());
        return customAttr;
    }

    public boolean equals(Object object) {
        return object instanceof CustomAttr && ((CustomAttr)object).renderer == this.renderer && super.equals(object);
    }

    public ChartAxisPosition getAxisPosition() {
        ChartAxisPosition chartAxisPosition = ChartAxisPosition.AXIS_LEFT;
        if (this.getDataSeriesConditionCount() <= 0) {
            return chartAxisPosition;
        }
        if (this.renderer == ChartCustomRendererType.BAR_RENDERER || this.renderer == ChartCustomRendererType.BAR_STACK) {
            AttrBarSeries attrBarSeries = (AttrBarSeries)this.getDataSeriesCondition(0);
            chartAxisPosition = attrBarSeries.getAxisPosition();
        } else if (this.renderer == ChartCustomRendererType.BAR3D || this.renderer == ChartCustomRendererType.BAR3D_STACK) {
            AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getDataSeriesCondition(0);
            chartAxisPosition = attrAxisPosition.getAxisPosition();
        } else if (this.renderer == ChartCustomRendererType.LINE_RENDERER) {
            AttrLineSeries attrLineSeries = (AttrLineSeries)this.getDataSeriesCondition(0);
            chartAxisPosition = attrLineSeries.getAxisPosition();
        } else if (this.renderer == ChartCustomRendererType.AREA_STACK) {
            AttrAreaSeries attrAreaSeries = (AttrAreaSeries)this.getDataSeriesCondition(0);
            chartAxisPosition = attrAreaSeries.getAxisPosition();
        }
        return chartAxisPosition;
    }

    public CustomAttr getNormalConditionAttr() {
        DataSeriesCondition dataSeriesCondition;
        CustomAttr customAttr = new CustomAttr(this.renderer);
        customAttr.setCondition(this.getCondition());
        if (this.getExisted(AttrLineSeries.class) != null) {
            dataSeriesCondition = this.getExisted(AttrLineSeries.class);
            ((AttrLineSeries)dataSeriesCondition).addNormalAttrConditions(customAttr.getAttributeList2Change());
        }
        if (this.getExisted(AttrAreaSeries.class) != null) {
            dataSeriesCondition = this.getExisted(AttrAreaSeries.class);
            ((AttrAreaSeries)dataSeriesCondition).addNormalAttrConditions(customAttr.getAttributeList2Change());
        }
        if (customAttr.getExisted(AttrMarkerType.class) == null) {
            customAttr.addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        }
        return customAttr;
    }

    public boolean needTransformToNormalCondition() {
        return this.renderer == ChartCustomRendererType.AREA_STACK || this.renderer == ChartCustomRendererType.LINE_RENDERER;
    }

    public boolean has3DShape() {
        return this.renderer == ChartCustomRendererType.BAR3D || this.renderer == ChartCustomRendererType.BAR3D_STACK;
    }

    public void changeTo3DRenderer() {
        if (this.renderer == ChartCustomRendererType.BAR_RENDERER) {
            this.useRenderer = ChartCustomRendererType.BAR3D;
        } else if (this.renderer == ChartCustomRendererType.BAR_STACK) {
            this.useRenderer = ChartCustomRendererType.BAR3D_STACK;
        }
    }

    public boolean is2DBarShapeRender() {
        return this.useRenderer == ChartCustomRendererType.BAR_RENDERER || this.useRenderer == ChartCustomRendererType.BAR_STACK;
    }

    public boolean isStackedBarShape() {
        return this.useRenderer == ChartCustomRendererType.BAR_STACK || this.useRenderer == ChartCustomRendererType.BAR3D_STACK;
    }

    public boolean isBarShapeRender() {
        return this.renderer == ChartCustomRendererType.BAR_RENDERER || this.renderer == ChartCustomRendererType.BAR_STACK || this.renderer == ChartCustomRendererType.BAR3D || this.renderer == ChartCustomRendererType.BAR_STACK;
    }

    public Integer[] getStackedSeriesList(List list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.isStackedBarShape()) {
            Calculator calculator = Calculator.createCalculator();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DataSeries dataSeries = (DataSeries)list.get(i2);
                if (!this.eval(dataSeries, calculator)) continue;
                arrayList.add(new Integer(dataSeries.getSeriesIndex()));
            }
        }
        return arrayList.toArray(new Integer[0]);
    }

    public Integer[] getStackedSeriesList(int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.isStackedBarShape()) {
            Calculator calculator = Calculator.createCalculator();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.eval(new SimpleResult(i2), calculator)) continue;
                arrayList.add(new Integer(i2));
            }
        }
        return arrayList.toArray(new Integer[0]);
    }

    public CustomAttr createSimpleCustomAttr() {
        DataSeriesCondition dataSeriesCondition;
        CustomAttr customAttr = new CustomAttr();
        try {
            if (this.getCondition() != null) {
                customAttr.setCondition((AbstractCondition)this.getCondition().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage());
        }
        customAttr.setName(new String(this.getName()));
        if (this.getExisted(AttrColor.class) != null) {
            dataSeriesCondition = this.getExisted(AttrColor.class);
            customAttr.addDataSeriesCondition(new AttrBackground(ColorBackground.getInstance(dataSeriesCondition.getSeriesColor())));
        }
        if (this.getExisted(AttrBackground.class) != null) {
            dataSeriesCondition = this.getExisted(AttrBackground.class);
            customAttr.addDataSeriesCondition(dataSeriesCondition);
        }
        if (this.getExisted(AttrContents.class) != null) {
            dataSeriesCondition = this.getExisted(AttrContents.class);
            customAttr.addDataSeriesCondition(dataSeriesCondition);
        }
        if (this.getExisted(AttrAlpha.class) != null) {
            dataSeriesCondition = this.getExisted(AttrAlpha.class);
            customAttr.addDataSeriesCondition(dataSeriesCondition);
        }
        return customAttr;
    }

    public CustomAttr createTypeConditionAttr() {
        CustomAttr customAttr = new CustomAttr();
        customAttr.setRenderer(this.getRenderer());
        try {
            if (this.getCondition() != null) {
                customAttr.setCondition((AbstractCondition)this.getCondition().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage());
        }
        customAttr.setName(new String(this.getName()));
        ChartAxisPosition chartAxisPosition = ChartAxisPosition.AXIS_LEFT;
        int n2 = 5;
        String string = "NullMarker";
        if (this.getExisted(AttrAxisPosition.class) != null) {
            chartAxisPosition = this.getExisted(AttrAxisPosition.class).getAxisPosition();
        }
        if (this.getExisted(AttrMarkerType.class) != null) {
            string = this.getExisted(AttrMarkerType.class).getMarkerType();
        }
        if (this.getExisted(AttrLineStyle.class) != null) {
            n2 = this.getExisted(AttrLineStyle.class).getLineStyle();
        }
        if (this.renderer == ChartCustomRendererType.BAR_RENDERER || this.renderer == ChartCustomRendererType.BAR_STACK) {
            AttrBarSeries attrBarSeries = new AttrBarSeries();
            customAttr.addDataSeriesCondition(attrBarSeries);
            attrBarSeries.setAxisPosition(chartAxisPosition);
        } else if (this.renderer == ChartCustomRendererType.LINE_RENDERER) {
            AttrLineSeries attrLineSeries = new AttrLineSeries();
            customAttr.addDataSeriesCondition(attrLineSeries);
            attrLineSeries.setAxisPosition(chartAxisPosition);
            attrLineSeries.setMarkerType(string);
            attrLineSeries.setLineStyle(n2);
        } else if (this.renderer == ChartCustomRendererType.AREA_STACK) {
            AttrAreaSeries attrAreaSeries = new AttrAreaSeries();
            customAttr.addDataSeriesCondition(attrAreaSeries);
            attrAreaSeries.setAxisPosition(chartAxisPosition);
            attrAreaSeries.setMarkerType(string);
        }
        return customAttr;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("renderer", this.renderer.getRendererType());
        jSONObject.put("useRenderer", this.useRenderer.getRendererType());
        return jSONObject;
    }

    public JSONObject exportConditionConfig() throws JSONException {
        JSONObject jSONObject = super.exportConditionConfig();
        jSONObject.put("renderer", this.renderer.getRendererType());
        return jSONObject;
    }
}

