/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartComparatorUtils;
import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.ComparatorUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;

public class Bubble
extends SpecialGlyph {
    private static final long serialVersionUID = -6475998623025879245L;
    private static final float ALPHA = 0.6f;
    private Rectangle2D bounds;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double radius = 0.0;
    private ColorInfo colorInfo = new ColorInfo();

    public Bubble() {
        this(0.0, 0.0, 0.0);
    }

    public Bubble(double d2, double d3, double d4) {
        this.centerX = d2;
        this.centerY = d3;
        this.radius = d4;
        this.setBounds(new Rectangle2D.Double(d2 - d4, d3 - d4, d4 * 2.0, d4 * 2.0));
    }

    public void setCenterX(double d2) {
        this.centerX = d2;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterY(double d2) {
        this.centerY = d2;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setRadius(double d2) {
        this.radius = d2;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    private void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public void draw(Graphics graphics, int n2) {
        if (this.radius <= 1.0) {
            return;
        }
        Arc2D.Double double_ = new Arc2D.Double(this.centerX - this.radius - 1.0, this.centerY - this.radius - 1.0, 2.0 * (this.radius + 1.0), 2.0 * (this.radius + 1.0), 0.0, 360.0, 0);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        Color color = this.colorInfo.getSeriesAttrColor().getSeriesColor();
        if (color == null) {
            return;
        }
        graphics2D.setPaint(color);
        graphics2D.fill(double_);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.draw(double_);
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public Shape getShape() {
        return this.bounds;
    }

    public boolean equals(Object object) {
        return object instanceof Bubble && ChartComparatorUtils.equals(((Bubble)object).bounds, this.bounds) && ComparatorUtils.equals(((Bubble)object).colorInfo, this.colorInfo) && ((Bubble)object).centerX == this.centerX && ((Bubble)object).centerY == this.centerY && ((Bubble)object).radius == this.radius && super.equals(object);
    }
}

