/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.present.Present;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.data.util.function.SumFunction;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.Inter;
import com.fr.script.Calculator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class TopChartData
implements ChartData {
    public static final String XML_TAG = "TopChartData";
    protected static final int HUGE_DATA = 1000;
    protected List categoryPresentList = new ArrayList();
    protected List seriesPresentList = new ArrayList();

    public void clearSeries() {
        this.seriesPresentList.clear();
    }

    public void addSeriesPresent(Object object) {
        this.seriesPresentList.add(object);
    }

    public void addCategoryPresent(Object object) {
        this.categoryPresentList.add(object);
    }

    public void clearCate() {
        this.categoryPresentList.clear();
    }

    public Object getCategoryPresentLabel(int n2) {
        if (this.categoryPresentList != null && n2 < this.categoryPresentList.size()) {
            return this.categoryPresentList.get(n2);
        }
        return this.getCategoryOriginalLabel(n2);
    }

    public abstract void dealPresent(Present var1, Present var2, Calculator var3);

    protected Object[] getSeriesItems() {
        return new Object[0];
    }

    protected Object[][] getXValue2D() {
        return new Object[0][0];
    }

    public Number getX(int n2, int n3) {
        return this.getDataValue(n2, n3, this.getXValue2D());
    }

    public Object getPresentItem(int n2) {
        if (this.seriesPresentList != null && n2 < this.seriesPresentList.size()) {
            return this.seriesPresentList.get(n2);
        }
        return this.getOriginalItem(n2);
    }

    public Object getOriginalItem(int n2) {
        Object[] objectArray = this.getSeriesItems();
        if (objectArray != null && n2 < objectArray.length) {
            return objectArray[n2];
        }
        return null;
    }

    public int getItemCount() {
        return this.getSeriesItems() == null ? 0 : this.getSeriesItems().length;
    }

    public abstract void dealHugeData();

    public abstract void dealDiscard(int var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6);

    protected void dealDiscardOther2DValue(int n2, int n3, boolean bl, boolean bl2, List list) {
        Object object;
        List list2;
        int n4;
        int n5 = list.size();
        int n6 = n5 > 0 ? ((List)list.get(0)).size() : 0;
        n2 = n2 != -1 && n2 < n6 ? n2 : n6;
        int n7 = n3 = n3 != -1 && n3 < n5 ? n3 : n5;
        if (bl2) {
            for (n4 = n5 - 1; n4 >= n3 && n4 < list.size(); --n4) {
                list.remove(n4);
            }
        } else {
            for (n4 = n5 - 1; n4 > n3 && n4 < list.size(); --n4) {
                list2 = (List)list.remove(n4);
                object = (List)list.get(n4 - 1);
                SumFunction sumFunction = new SumFunction();
                for (int i2 = 0; object != null && i2 < object.size(); ++i2) {
                    sumFunction.reset();
                    if (i2 < list2.size()) {
                        sumFunction.addData(list2.get(i2));
                    }
                    if (i2 < object.size()) {
                        sumFunction.addData(object.remove(i2));
                    }
                    if (n3 == n5) continue;
                    object.add(i2, sumFunction.getResult());
                }
            }
        }
        if (bl) {
            for (n4 = 0; n4 < n3 && n4 < list.size(); ++n4) {
                list2 = (List)list.get(n4);
                for (int i3 = n6 - 1; i3 >= n2 && list2 != null && i3 < list2.size(); --i3) {
                    list2.remove(i3);
                }
            }
        } else {
            for (n4 = 0; n4 < n3 && n4 < list.size(); ++n4) {
                list2 = (List)list.get(n4);
                object = new SumFunction();
                for (int i4 = n6 - 1; i4 >= n2 && list2 != null && i4 < list2.size(); --i4) {
                    ((SumFunction)object).addData(list2.remove(i4));
                }
                if (n2 == n6 || list2 == null) continue;
                list2.add(((SumFunction)object).getResult());
            }
        }
    }

    protected void dealDiscardOtherList(int n2, boolean bl, List list, boolean bl2) {
        int n3 = list.size();
        int n4 = n2 = n2 != -1 ? n2 : n3;
        if (bl) {
            for (int i2 = n3 - 1; i2 >= n2; --i2) {
                list.remove(i2);
            }
        } else if (list.size() > n2) {
            if (bl2) {
                for (int i3 = n3 - 1; i3 >= n2; --i3) {
                    list.remove(i3);
                }
                if (n2 != n3) {
                    list.add(Inter.getLocText("ParameterD-The_Other"));
                }
            } else {
                SumFunction sumFunction = new SumFunction();
                for (int i4 = n3 - 1; i4 >= n2; --i4) {
                    sumFunction.addData(list.remove(i4));
                }
                if (n2 != n3) {
                    list.add(sumFunction.getResult());
                }
            }
        }
    }

    protected Number getDataValue(int n2, int n3, Object[][] objectArray) {
        if (objectArray == null || objectArray.length <= n2 || n2 < 0) {
            return null;
        }
        Object[] objectArray2 = objectArray[n2];
        if (objectArray2.length <= n3) {
            return null;
        }
        return this.getObjectNumber(n3, objectArray2);
    }

    protected Number getObjectNumber(int n2, Object[] objectArray) {
        if (objectArray == null || n2 >= objectArray.length) {
            return null;
        }
        return this.dealDataObject2Number(objectArray[n2]);
    }

    protected Number dealDataObject2Number(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            Double d2 = new Double(number.doubleValue());
            if (d2.isInfinite()) {
                return null;
            }
            return number;
        }
        if (object == null) {
            return null;
        }
        Number number = Utils.objectToNumber(object, true);
        if (number != null) {
            return number;
        }
        Date date = DateUtils.object2Date(object, true);
        if (date != null) {
            return new Double(ChartBaseUtils.date2Int(date, 6));
        }
        try {
            return Double.valueOf(Utils.objectToString(object));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return object instanceof TopChartData && ComparatorUtils.equals((Object)((TopChartData)object).seriesPresentList, (Object)this.seriesPresentList) && ComparatorUtils.equals((Object)((TopChartData)object).categoryPresentList, (Object)this.categoryPresentList);
    }
}

