/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Formula;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.TimeSwitchAttr;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryAxisGlyph;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryAxis
extends Axis {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "CategoryAxis";
    private int mainType = 1;
    private int secondType = 1;
    private boolean isDate;
    private ArrayList<TimeSwitchAttr> timeSwitchMap = new ArrayList();

    public CategoryAxis() {
        this(3);
    }

    public CategoryAxis(int n2) {
        this(n2, false);
    }

    public CategoryAxis(int n2, boolean bl) {
        this.position = n2;
        this.isDate = bl;
        this.setMainGridStyle(0);
        this.setMainGridColor(new Color(192, 192, 192));
    }

    @Override
    public AxisGlyph createAxisGlyph(ChartData chartData) {
        CategoryAxisGlyph categoryAxisGlyph = this.isDate ? new DateAxisGlyph() : new CategoryAxisGlyph();
        this.initAxisGlyph(categoryAxisGlyph, chartData);
        double[] dArray = this.getDateRange(chartData);
        categoryAxisGlyph.initMinMaxValue(dArray[0], dArray[1]);
        if (chartData instanceof NormalChartData) {
            int n2;
            int n3;
            NormalChartData normalChartData = (NormalChartData)chartData;
            Object[] objectArray = normalChartData.getSecondCates();
            Object[] objectArray2 = normalChartData.getThirdCates();
            int n4 = objectArray == null ? 0 : objectArray.length;
            int n5 = n3 = objectArray2 == null ? 0 : objectArray2.length;
            if (n4 > 0 || n3 > 0) {
                categoryAxisGlyph.setZoom(false);
            }
            if (n3 > 0) {
                n4 = n3 * n4;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                categoryAxisGlyph.addSecondLabel(objectArray[n2 % objectArray.length]);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                categoryAxisGlyph.addThirdLabel(objectArray2[n2]);
            }
        }
        return categoryAxisGlyph;
    }

    public void initAxisGlyph(CategoryAxisGlyph categoryAxisGlyph, ChartData chartData) {
        super.initAxisGlyph(categoryAxisGlyph);
        int n2 = chartData.getCategoryLabelCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            categoryAxisGlyph.addCategoryLabel(chartData.getCategoryPresentLabel(i2) == null ? "" : chartData.getCategoryPresentLabel(i2));
        }
        categoryAxisGlyph.setMainType(this.getMainType());
        categoryAxisGlyph.setSecondType(this.getSecondType());
        if (this.isDate()) {
            categoryAxisGlyph.setTimeSwitchMap(this.timeSwitchMap);
        }
    }

    private boolean checkIsCouldChangeDate(ChartData chartData) {
        int n2 = chartData.getCategoryLabelCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Date date;
            if (chartData.getCategoryPresentLabel(i2) == null || (date = DateUtils.object2Date(chartData.getCategoryPresentLabel(i2), true)) != null) continue;
            return false;
        }
        return true;
    }

    private double[] getDateRange(ChartData chartData) {
        if (!this.isDate || !this.checkIsCouldChangeDate(chartData)) {
            return new double[]{0.0, chartData.getCategoryLabelCount()};
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n2 = chartData.getCategoryLabelCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Date date;
            if (chartData.getCategoryPresentLabel(i2) == null || (date = DateUtils.object2Date(chartData.getCategoryPresentLabel(i2), true)) == null) continue;
            double d4 = ChartBaseUtils.date2Int(date, 6);
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        return new double[]{d2, d3};
    }

    public void setMainType(int n2) {
        this.mainType = n2;
    }

    public int getMainType() {
        return this.mainType;
    }

    public void setSecondType(int n2) {
        this.secondType = n2;
    }

    public int getSecondType() {
        return this.secondType;
    }

    @Override
    public boolean isDate() {
        return this.isDate;
    }

    public void setDate(boolean bl) {
        this.isDate = bl;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            Object object;
            String string = xMLableReader.getTagName();
            if (string.equals("DateAxis201106")) {
                this.mainType = xMLableReader.getAttrAsInt("mainType", 1);
                this.secondType = xMLableReader.getAttrAsInt("secondType", 1);
                this.setDate(true);
            }
            if (string.equals("newDateAxisAttr") || string.equals("DateAxisAttr")) {
                this.setCustomMainUnit(xMLableReader.getAttrAsBoolean("isCustomMainDate", false));
                this.mainType = xMLableReader.getAttrAsInt("mainType", 1);
                this.setCustomSecUnit(xMLableReader.getAttrAsBoolean("isCustomSecondDate", false));
                this.secondType = xMLableReader.getAttrAsInt("secondType", 1);
                object = xMLableReader.getAttrAsString("mainDate", "0");
                if (object != null) {
                    this.setMainUnit(new Formula((String)object));
                }
                if ((object = xMLableReader.getAttrAsString("secondDate", "0")) != null) {
                    this.setSecUnit(new Formula((String)object));
                }
                this.setDate(true);
            }
            if (string.equals("DateAxisAttr")) {
                this.setCustomMinValue(xMLableReader.getAttrAsBoolean("isCustomMinValue", false));
                this.setMinValue(new Formula(xMLableReader.getAttrAsString("minValue", "0")));
                this.setCustomMaxValue(xMLableReader.getAttrAsBoolean("isCustomMaxValue", false));
                this.setMaxValue(new Formula(xMLableReader.getAttrAsString("maxValue", "0")));
                this.setDate(true);
            }
            if (string.equals("singleTimeSwitch")) {
                object = new TimeSwitchAttr();
                ((TimeSwitchAttr)object).readXML(xMLableReader);
                this.timeSwitchMap.add((TimeSwitchAttr)object);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        if (this.isDate) {
            xMLPrintWriter.startTAG("DateAxis201106").attr("mainType", this.mainType).attr("secondType", this.secondType).end();
        }
        if (!this.timeSwitchMap.isEmpty()) {
            xMLPrintWriter.startTAG("timeSwitchMap");
            for (TimeSwitchAttr timeSwitchAttr : this.timeSwitchMap) {
                timeSwitchAttr.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CategoryAxis && ((CategoryAxis)object).isDate() == this.isDate() && ((CategoryAxis)object).mainType == this.mainType && ((CategoryAxis)object).secondType == this.secondType && ComparatorUtils.equals(((CategoryAxis)object).timeSwitchMap, this.timeSwitchMap) && super.equals(object);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CategoryAxis categoryAxis = (CategoryAxis)super.clone();
        categoryAxis.setDate(this.isDate);
        categoryAxis.mainType = this.mainType;
        categoryAxis.secondType = this.secondType;
        categoryAxis.resetTimeSwitchMap();
        for (TimeSwitchAttr timeSwitchAttr : this.getTimeSwitchMap()) {
            categoryAxis.getTimeSwitchMap().add((TimeSwitchAttr)timeSwitchAttr.clone());
        }
        return categoryAxis;
    }

    @Override
    public boolean isSupportAxisLabelWrap() {
        return this.axisData.isLabelWrapShow;
    }

    @Override
    public ArrayList<TimeSwitchAttr> getTimeSwitchMap() {
        return this.timeSwitchMap;
    }

    private void resetTimeSwitchMap() {
        this.timeSwitchMap = new ArrayList();
    }
}

