/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class AttrBackground
extends DataSeriesCondition {
    private static final long serialVersionUID = -2629309796122971477L;
    public static final String XML_TAG = "AttrBackground";
    private Background seriesBackground = null;
    private boolean shadow = false;

    public AttrBackground() {
    }

    public AttrBackground(Background background) {
        this.seriesBackground = background;
    }

    public void setSeriesBackground(Background background) {
        this.seriesBackground = background;
    }

    public Background getSeriesBackground() {
        return this.seriesBackground;
    }

    public void setShadow(boolean bl) {
        this.shadow = bl;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Background")) {
                this.setSeriesBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if (string.equals("Attr")) {
                this.setShadow(xMLableReader.getAttrAsBoolean("shadow", false));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        BaseXMLUtils.writeBackground(xMLPrintWriter, this.seriesBackground);
        xMLPrintWriter.startTAG("Attr").attr("shadow", this.shadow).end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        AttrBackground attrBackground = (AttrBackground)super.clone();
        if (this.seriesBackground != null) {
            attrBackground.seriesBackground = (Background)this.seriesBackground.clone();
        }
        return attrBackground;
    }

    public boolean equals(Object object) {
        return object instanceof AttrBackground && ComparatorUtils.equals(((AttrBackground)object).seriesBackground, this.seriesBackground) && ((AttrBackground)object).shadow == this.shadow;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesBackground != null) {
            jSONObject.put("seriesBackground", ChartBaseUtils.background2JS(repository, this.seriesBackground));
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

