;(function($){
    // FR.TreeNodeToggleButton start
    FR.TreeNodeToggleButton = FR.extend(FR.ToggleButton, {
        selected_class: 'x-treenode-expand',
        unselected_class: 'x-treenode-unexpand',
        son_array: undefined,
        expand_state: false,

        _init: function () {
            FR.TreeNodeToggleButton.superclass._init.apply(this, arguments);
            // b:ie paint special to change
            if (FR.Browser.isIE()) {
                this.$btn.css('background-position', '-1px -2px');
            }
        },

        _node_init: function () {
            var o = this.options = $.extend({
                expand: false
            }, this.options);

            if (o.sonarray && o.sonarray.length > 1) {
                if (o.sonarray[0] == -1) {
                    this.expand_mode = 0;
                } else {
                    this.expand_mode = 1;
                }

                var contentPane = _g();
                var cp = contentPane.curLGP;

                if (!contentPane.TREEMGR) {
                    contentPane.TREEMGR = [];
                    // 耦合很高，但这控件并不算是普遍空间
                    contentPane.on(FR.Events.STARTLOAD, function (pane) {
                        if (contentPane.TREEMGR && pane) {
                            contentPane.TREEMGR[pane.idx] = null;
                        }
                    });
                }

                if (!contentPane.TREEMGR[o.reportIndex]) {
                    contentPane.TREEMGR[o.reportIndex] = {};
                    contentPane.TREEMGR[o.reportIndex].nodes = [];
                    contentPane.TREEMGR[o.reportIndex].location_nodes = {};
                }

                // 不是view的特殊处理的话
                if (!this.options.parNode) {
                    for (var i = 0; i < contentPane.TREEMGR[o.reportIndex].nodes.length; i++) {
                        var treenode = contentPane.TREEMGR[o.reportIndex].nodes[i];
                        if (this.initNodeLayer(treenode)) {
                            break;
                        }
                    }

                    if (!this.parentNode) {
                        contentPane.TREEMGR[o.reportIndex].nodes[contentPane.TREEMGR[o.reportIndex].nodes.length] = this;
                    }
                } else {
                    if (this.options.parNode != 'null') {
                        this.parent = contentPane.TREEMGR[o.reportIndex].location_nodes[this.options.parNode];
                        if (this.parent) {
                            if (this.parent.sonNodes) {
                                this.parent.sonNodes[this.parent.sonNodes.length] = this;
                            } else {
                                this.parent.sonNodes = [];
                                this.parent.sonNodes[0] = this;
                            }
                        }
                    }

                    contentPane.TREEMGR[o.reportIndex].location_nodes[this.options.location] = this;
                }

                this.mgr = contentPane.TREEMGR[this.options.reportIndex];
                if (!this.mgr.row_expand_state) {
                    this.mgr.row_expand_state = [];
                    this.mgr.col_expand_state = [];

                    for (var i = 1; i < this.options.sonarray.length; i++) {
                        if (this.expand_mode === 0) {
                            this.mgr.row_expand_state[this.options.sonarray[i]] = 0;
                        } else if (this.expand_mode === 1) {
                            this.mgr.col_expand_state[this.options.sonarray[i]] = 0;
                        }
                    }
                }

                this.cells = [];
            } else {
                this.expand_mode = -1; // -1不理睬 0纵向 1横向
            }

        },

        initNodeLayer: function (treenode) {
            if (treenode.expand_mode == this.expand_mode) {
                var matchValue = this.options.sonarray[1];
                // 进行匹配，有一个在里面就是子节点了
                for (var s = 1; s < treenode.options.sonarray.length; s++) {
                    if (matchValue == treenode.options.sonarray[s]) {
                        if (treenode.sonNodes) {
                            for (var n = 0; n < treenode.sonNodes.length; n++) {
                                if (this.initNodeLayer(treenode.sonNodes[n])) {
                                    return true;
                                }
                            }

                            treenode.sonNodes[treenode.sonNodes.length] = this;
                            this.parentNode = treenode;
                        } else {
                            treenode.sonNodes = [];
                            treenode.sonNodes[0] = this;
                            this.parentNode = treenode;
                        }

                        return true;
                    } else if (matchValue < treenode.options.sonarray[s]) {
                        return false;
                    }
                }
            }

            return false;
        },

        onNodeClick: function () {
            this.treeNodeClick();
        },
        // 树节点的点击
        treeNodeClick: function () {
            if (!this.options.sonarray) {
                // nothing
            } else {
                this.TreeNodeAction(!this.expand_state);
            }

            this.fireEvent(FR.Events.CLICK);
            // 这里这个事件主要用于移动平台重新计算滚动区域
            _g().fireEvent("refresh");
        },

        /**
         * ie9下隐藏行设置 bug:55354,ie9下点击节点按钮，由于计算格子边框导致浏览器崩溃，这样处理下
         */
        hideTr: function(element) {
            if (FR.Browser.isIE9()) {
                var table = null;
                var obj = $(element);
                for (; !obj.is('BODY'); obj = obj.parent()) {
                    if (obj.is('TABLE')) {
                        table = obj;
                        break;
                    }
                }
                if (table == null) {
                    return;
                }
                var initValue = table.css("border-collapse");
                table.css("border-collapse", "separate");
                $(element).css("display", this.expand_state ? "none" : "");
                table.css("border-collapse", initValue);
            } else {
                $(element).css("display", this.expand_state ? "none" : "");
            }
        },

        // 把子节点控制的行列在自身中去除
        dealwithSelfSonArray: function () {
            if (this.options.needInit === false) {
                this.result_son_array = this.options.sonarray;
            } else if (this.sonNodes) {
                for (var i = 0; i < this.sonNodes.length; i++) {
                    var n = 1;
                    for (var j = 1; j < this.sonNodes[i].options.sonarray.length
                    && n < this.options.sonarray.length; j++) {
                        if (this.options.sonarray[n] == -1
                            || this.sonNodes[i].options.sonarray[j] > this.options.sonarray[n]) {
                            j--;
                            n++;
                            continue;
                        } else if (this.sonNodes[i].options.sonarray[j] == this.options.sonarray[n]) {
                            this.options.sonarray[n] = -1;
                            n++;
                            continue;
                        }
                    }
                }

                this.result_son_array = [];
                this.result_son_array[0] = this.options.sonarray[0];
                for (var i = 1; i < this.options.sonarray.length; i++) {
                    if (this.options.sonarray[i] >= 0) {
                        this.result_son_array[this.result_son_array.length] = this.options.sonarray[i];
                    }
                }
            } else {
                this.result_son_array = this.options.sonarray;
            }

            // 表示是纵向收缩的
            if (this.expand_mode === 0) {
                var tr;
                for (var i = this.result_son_array.length - 1; i > 0; i--) {
                    tr = this.mgr.tr_array[this.result_son_array[i]];
                    if (!tr.hasClass('tntr')) {
                        this.result_son_array.splice(i, 1); // 没有就不是控制下的
                    }
                }
            }
        },

        // 伸缩处理
        TreeNodeAction: function (expand) {
            if (expand == this.expand_state) {
                return;
            }
            var self = this;
            if (!this.mgr) {
                this.mgr = _g().TREEMGR[this.options.reportIndex];
            }
            if (!this.mgr.tr_array) {
                var contentPane = _g().curLGP;
                this.mgr.tr_array = [];
                var tr;
                var $center = $('.frozen-center', contentPane.$container);
                var $west = $('.frozen-west', contentPane.$container);
                var $north = $('.frozen-north', contentPane.$container);
                var targetDomElement = $center;
                // 说明是west区域包含折叠树控件
                if ($west.length > 0 && $west[0].contains(this.$btn[0])) {
                    targetDomElement = $west;
                } else if ($north.length > 0 && $north[0].contains(this.$btn[0])) {
                    targetDomElement = $north;
                }
                // 与655不同，如果冻结$container下面还有个tbody的,并且没有把frozen-center放在第一个。
                var $table = $("table:eq(0)", targetDomElement.length > 0
                    ? targetDomElement
                    : contentPane.$container);
                $.each(($table.children("tbody")).children("tr[tridx]"), function (idx, item) {
                    tr = $(item);
                    self.mgr.tr_array[parseInt(tr.attr("tridx"))] = tr;
                });
            }
            if (!this.result_son_array) {
                this.dealwithSelfSonArray();
            }
            this.selected(expand);

            // 表示是纵向收缩的
            if (this.expand_mode === 0) {
                var tr;
                for (var i = 1; i < this.result_son_array.length; i++) {
                    tr = this.mgr.tr_array[this.result_son_array[i]];
                    if (tr) {
                        this.hideTr(tr);
                        // ie 不但要弄tr td也需要弄
                        if (FR.Browser.isIE()) {
                            if (!this.cells[this.result_son_array[i]]) {
                                this.cells[this.result_son_array[i]] = [];
                                var td;
                                $.each(tr.children("td[tdcol]"), function (index, item) {
                                    td = $(item);
                                    self.cells[self.result_son_array[i]][parseInt(td.attr("tdcol"))] = td;
                                });
                            }

                            $.each(this.cells[this.result_son_array[i]], function (index, td) {
                                if (!td || (!self.expand_state && (self.mgr.col_expand_state[index] === 0
                                    || (self.mgr.col_expand_state[index] == null && td.attr("realhd") != null)))) {
                                    return;
                                }
                                td.css("display", self.expand_state ? "none" : "");
                            });
                        }

                        this.mgr.row_expand_state[this.result_son_array[i]] = this.expand_state
                            ? 0
                            : 1;
                    }
                }
                // 横向
            } else if (this.expand_mode === 1) {
                var rowcount = this.result_son_array[0];
                var td;
                var col;
                if (!this.mgr.td_table) {
                    this.mgr.td_table = [];
                    $.each(self.mgr.tr_array, function (idx, tr) {
                        if (tr) {
                            $.each(tr.children("td[tdcol]"), function (iidx, td) {
                                td = $(td);
                                col = parseInt(td.attr("tdcol"));
                                if (!self.mgr.td_table[col]) {
                                    self.mgr.td_table[col] = [];
                                }
                                self.mgr.td_table[col][idx] = td;
                            });
                        }
                    });
                }

                var td_array;
                for (var i = 1; i < self.result_son_array.length; i++) {
                    td_array = self.mgr.td_table[self.result_son_array[i]];
                    if (td_array) {
                        $.each(td_array, function (idx, td) {
                            if (td) {
                                if (!self.expand_state && self.mgr.row_expand_state[idx] === 0) {
                                    if(FR.Browser.isIE()){
                                        return;
                                    }
                                }
                                td.css("display", self.expand_state ? "none" : "");
                            }
                        });
                    }
                }

                for (var i = 1; i < this.result_son_array.length; i++) {
                    this.mgr.col_expand_state[this.result_son_array[i]] = this.expand_state
                        ? 0
                        : 1;
                }
            }

            if (this.sonNodes) {
                if (this.expand_state) {
                    this.last_son_state = [];
                    for (var i = 0; i < this.sonNodes.length; i++) {
                        this.last_son_state[i] = this.sonNodes[i].selected();
                        this.sonNodes[i].TreeNodeAction(false);
                    }
                } else if (this.last_son_state) {
                    for (var i = 0; i < this.sonNodes.length; i++) {
                        this.sonNodes[i].TreeNodeAction(this.last_son_state[i]);
                    }
                }
            }

            this.expand_state = !this.expand_state;
        }
    });
    $.shortcut("treenode", FR.TreeNodeToggleButton)
})(jQuery);