package com.jshx.zzhxmhistory.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxmhistory.dao.ZzhxmHistoryDao;
import com.jshx.zzhxmhistory.entity.ZzhxmHistory;
import com.jshx.zzhxmhistory.service.ZzhxmHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmHistoryService")
public class ZzhxmHistoryServiceImpl extends BaseServiceImpl implements ZzhxmHistoryService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhxmHistoryDao")
	private ZzhxmHistoryDao zzhxmHistoryDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmHistoryDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmHistory getById(String id)
	{
		return zzhxmHistoryDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxm 信息
	 */
	@Transactional
	public void save(ZzhxmHistory zzhxm)
	{
		zzhxmHistoryDao.save(zzhxm);
	}

	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	@Transactional
	public void update(ZzhxmHistory zzhxm)
	{
		zzhxmHistoryDao.update(zzhxm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmHistoryDao.findZzhxmHistory(paraMap);

		zzhxmHistoryDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmHistoryDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<ZzhxmHistory> findZzhxmHistory(Map<String, Object> paraMap) {

		return zzhxmHistoryDao.findZzhxmHistory(paraMap);

	}
}
