package com.jshx.zclb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zclb.entity.Zclb;
import com.jshx.zclb.dao.ZclbDao;

@Component("zclbDao")
public class ZclbDaoImpl extends BaseDaoImpl implements ZclbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZclbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZclb(Map<String, Object> paraMap){
		return this.findListByHqlId("findZclbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zclb getById(String id)
	{
		return (Zclb)this.getObjectById(Zclb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Zclb zclb)
	{
		zclb.setId(null);
		this.saveOrUpdateObject(zclb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Zclb zclb)
	{
		this.saveOrUpdateObject(zclb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zclb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zclb zclb = (Zclb)this.getObjectById(Zclb.class, id);
		zclb.setDelFlag(1);
		this.saveObject(zclb);
	}
}
