package com.jshx.xgbz.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xgbz.entity.Xgbz;
import com.jshx.xgbz.dao.XgbzDao;

@Component("xgbzDao")
public class XgbzDaoImpl extends BaseDaoImpl implements XgbzDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXgbzByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findXgbz(Map<String, Object> paraMap){
		return this.findListByHqlId("findXgbzByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xgbz getById(String id)
	{
		return (Xgbz)this.getObjectById(Xgbz.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xgbz xgbz)
	{
		xgbz.setId(null);
		this.saveOrUpdateObject(xgbz);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xgbz xgbz)
	{
		this.saveOrUpdateObject(xgbz);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Xgbz.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Xgbz xgbz = (Xgbz)this.getObjectById(Xgbz.class, id);
		xgbz.setDelFlag(1);
		this.saveObject(xgbz);
	}
}
