package com.jshx.tbshxk.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import com.jshx.core.utils.StringUtil;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.service.RfxmService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.tbshxk.entity.Tbshxk;
import com.jshx.tbshxk.service.TbshxkService;

public class TbshxkAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String jsdw;
	private String gcxmmc;
	private String czjb;

	/**
	 * 实体类
	 */
	private Tbshxk tbshxk = new Tbshxk();

	/**
	 * 业务类
	 */
	@Autowired
	private TbshxkService tbshxkService;

	@Autowired
	private RfxmService rfxmService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryFssjStart;

	private Date queryFssjEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != tbshxk){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != tbshxk.getGhxkzh()) && (0 < tbshxk.getGhxkzh().trim().length())){
				paraMap.put("ghxkzh", "%" + tbshxk.getGhxkzh().trim() + "%");
			}

			if ((null != tbshxk.getSlbh()) && (0 < tbshxk.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + tbshxk.getSlbh().trim() + "%");
			}

			if ((null != tbshxk.getJsdw()) && (0 < tbshxk.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + tbshxk.getJsdw().trim() + "%");
			}
			if ((null != tbshxk.getXxylb()) && (0 < tbshxk.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + tbshxk.getXxylb().trim() + "%");
			}
			if ((null != tbshxk.getFszt()) && (0 < tbshxk.getFszt().trim().length())){
				paraMap.put("fszt", "%" + tbshxk.getFszt().trim() + "%");
			}
			if ((null != tbshxk.getJfzt()) && (0 < tbshxk.getJfzt().trim().length())){
				paraMap.put("jfzt", "%" + tbshxk.getJfzt().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|ecn|ghxkzh|fgwbh|xxylb|slbh|jsdw|gcxmmc|xmdd|jfzt|pzbh|fszt|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = tbshxkService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != tbshxk)&&(null != tbshxk.getId()))
			tbshxk = tbshxkService.getById(tbshxk.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			tbshxk.setDeptId(this.getLoginUserDepartmentId());
			tbshxk.setDelFlag(0);
			tbshxkService.save(tbshxk);
		}else{
			tbshxkService.update(tbshxk);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != tbshxk)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到tbshxk中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }
	/**
	 * 重发
	 */
	public String sync() throws Exception{
		try{
			System.out.println(jsdw);
			System.out.println(gcxmmc);
			Tbshxk tbshxk1 = new Tbshxk();
			Map<String ,Object> map1 = new HashMap<>();
			map1.put("xxylb",ids);
			Pagination pagination  = tbshxkService.findByPage(new Pagination(1,0),map1);
			List<Tbshxk> p = pagination.getListOfObject();
			if(CollectionUtils.isEmpty(p))
			{
				this.getResponse().getWriter().println("{\"result\":false}");
				return null;
			}
			else
			{
				tbshxk1 = p.get(0);
				tbshxk1.setGcxmmc(gcxmmc);
				tbshxk1.setJsdw(jsdw);
			}
			String r =  CommonAction.send2wwSGXK(null,tbshxk1,null,null);
			if("false".equals(r) || StringUtil.isEmpty(r))
//			if(false)
			{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
			else
			{
				this.getResponse().getWriter().println("{\"result\":true}");
				tbshxk1.setJsdw(jsdw);
				tbshxk1.setGcxmmc(gcxmmc);
				tbshxkService.update(tbshxk1);
				//TODO 更新缴款通知书状态
				HashMap<String, Object> rfxmParam = new HashMap<>();
				rfxmParam.put("slbh",tbshxk1.getSlbh());
				List<Rfxm> rfxmList = rfxmService.findRfxm(rfxmParam);
				if(rfxmList != null && rfxmList.size() > 0) {//同步成功记录下，不允许再次同步了
					Rfxm rfxm = rfxmList.get(0);
					rfxm.setIsTb(1);
					rfxmService.update(rfxm);
				}
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}


	/**
	 * 修改财政级别并重发
	 */
	public String syncczjb() throws Exception{
		try{
			System.out.println(czjb);
			Tbshxk tbshxk1 = new Tbshxk();
			Map<String ,Object> map1 = new HashMap<>();
			map1.put("xxylb",ids);
			Pagination pagination  = tbshxkService.findByPage(new Pagination(1,0),map1);
			List<Tbshxk> p = pagination.getListOfObject();
			if(CollectionUtils.isEmpty(p))
			{
				this.getResponse().getWriter().println("{\"result\":false}");
				return null;
			}
			else
			{
				tbshxk1 = p.get(0);
				tbshxk1.setCzjb(czjb);
//				tbshxk1.setJsdw(jsdw);
			}
			String r =  CommonAction.send2wwSGXK(null,tbshxk1,null,null);
//			String r =  "true";
			if("false".equals(r) || StringUtil.isEmpty(r))
//			if(false)
			{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
			else
			{
				this.getResponse().getWriter().println("{\"result\":true}");
				tbshxk1.setCzjb(czjb);
//				tbshxk1.setGcxmmc(gcxmmc);
				tbshxkService.update(tbshxk1);
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}


	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			tbshxkService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Tbshxk getTbshxk(){
		return this.tbshxk;
	}

	public void setTbshxk(Tbshxk tbshxk){
		this.tbshxk = tbshxk;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryFssjStart(){
		return this.queryFssjStart;
	}

	public void setQueryFssjStart(Date queryFssjStart){
		this.queryFssjStart = queryFssjStart;
	}

	public Date getQueryFssjEnd(){
		return this.queryFssjEnd;
	}

	public void setQueryFssjEnd(Date queryFssjEnd){
		this.queryFssjEnd = queryFssjEnd;
	}

	public String getJsdw() {
		return jsdw;
	}

	public void setJsdw(String jsdw) {
		this.jsdw = jsdw;
	}

	public String getGcxmmc() {
		return gcxmmc;
	}

	public void setGcxmmc(String gcxmmc) {
		this.gcxmmc = gcxmmc;
	}

	public String getCzjb() {
		return czjb;
	}

	public void setCzjb(String czjb) {
		this.czjb = czjb;
	}
}
