package com.jshx.taskAssigneeRecord.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="TASK_ASSIGNEE_RECORD")
public class TaskAssigneeRecord extends BaseModel implements Comparable<TaskAssigneeRecord>
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 任务分配人
	 */
	private String taskAssigneer;

	/**
	 * 任务分配次数
	 */
	private long taskAssigneeTimes;

	/**
	 * 任务分配时间
	 */
	private String taskAssigneeDate;

	/**
	 * 任务节点KEY
	 */
	private String taskKey;

	public TaskAssigneeRecord(){
	}
	
	public TaskAssigneeRecord(String id, String taskAssigneer, long taskAssigneeTimes, String taskAssigneeDate, String taskKey){
		
		this.id = id;
		
		this.taskAssigneer = taskAssigneer;
		
		this.taskAssigneeTimes = taskAssigneeTimes;
		
		this.taskAssigneeDate = taskAssigneeDate;
		
		this.taskKey = taskKey;
	
	}

	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="TASK_ASSIGNEER")
	public String getTaskAssigneer()
	{
		return this.taskAssigneer;
	}

	public void setTaskAssigneer(String taskAssigneer)
	{
		this.taskAssigneer = taskAssigneer;
	}

	@Column(name="TASK_ASSIGNEE_TIMES")
	public long getTaskAssigneeTimes()
	{
		return this.taskAssigneeTimes;
	}

	public void setTaskAssigneeTimes(long taskAssigneeTimes)
	{
		this.taskAssigneeTimes = taskAssigneeTimes;
	}

	@Column(name="TASK_ASSIGNEE_DATE")
	public String getTaskAssigneeDate()
	{
		return this.taskAssigneeDate;
	}

	public void setTaskAssigneeDate(String taskAssigneeDate)
	{
		this.taskAssigneeDate = taskAssigneeDate;
	}

	@Column(name="TASK_KEY")
	public String getTaskKey()
	{
		return this.taskKey;
	}

	public void setTaskKey(String taskKey)
	{
		this.taskKey = taskKey;
	}

	@Override
	public int compareTo(TaskAssigneeRecord o) {
		return ((Long)this.taskAssigneeTimes).compareTo(o.getTaskAssigneeTimes());
	}

}
