package com.jshx.spjlb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.spjlb.dao.SpjlbDao;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;

@Service("spjlbService")
public class SpjlbServiceImpl extends BaseServiceImpl implements SpjlbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("spjlbDao")
	private SpjlbDao spjlbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return spjlbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Spjlb getById(String id)
	{
		return spjlbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Spjlb spjlb)
	{
		spjlbDao.save(spjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Spjlb spjlb)
	{
		spjlbDao.update(spjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=spjlbDao.findSpjlb(paraMap);
		
		spjlbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    spjlbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Spjlb> findSpjlball(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return spjlbDao.findSpjlb(paraMap);
	}

	@Override
	public Spjlb getByslbh(String id) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", id);
		List<Spjlb> ls=spjlbDao.findSpjlb(paraMap);
		if(ls.size()>0){
			return ls.get(0);
		}
		return null;
	}
}
