/**
 * @author luoj
 * @create 2009-6-14
 * @file ServletInitializerContainer.java
 * @since v0.1
 * 
 */
package com.jshx.sms;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;

import com.jshx.sms.ServletInitializer;



/**
 * @author luoj
 *
 */
public class ServletInitializerContainer implements ServletInitializer {
	private List<ServletInitializer> initializerList = null;
	
	public ServletInitializerContainer() {
		List<ServletInitializer> list = new ArrayList();
		list.add(new SMSQueueInitializer());
		this.initializerList = list;
	}
	
	public ServletInitializerContainer(List<ServletInitializer> initializerList ) {
		this.initializerList = initializerList;
	}
	/* (non-Javadoc)
	 * @see com.jsict.ictmap.web.init.ServletInitializer#initialize(javax.servlet.ServletConfig)
	 */
	public void initialize(ServletContextEvent sce) throws ServletException {
		for(ServletInitializer initializer : initializerList) {
			initializer.initialize(sce);
		}
	}

}
