package com.jshx.rebate.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.rebate.entity.Rebate;
import com.jshx.rebate.service.RebateService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

public class RebateAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Rebate rebate = new Rebate();

	/**
	 * 业务类
	 */
	@Autowired
	private RebateService rebateService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		List<Rebate> rabateList  = new ArrayList<Rebate>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		if(!this.getLoginUser().getIsSuperAdmin()){
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			   paraMap.put("zsdw", zsdw.getZsdw());
	        }   
		if(StringUtils.isNotEmpty(rebate.getSlbh()))
		{
			paraMap.put("slbh", "%"+rebate.getSlbh()+"%");
		}
		if(StringUtils.isNotEmpty(rebate.getDwmc()))
		{
			paraMap.put("dwmc", "%"+rebate.getDwmc()+"%");
		}
		//项目名称
		if(StringUtils.isNotEmpty(rebate.getXmmc()))
		{
			paraMap.put("xmmc", "%"+rebate.getXmmc()+"%");
		}
		//一般缴款书编号
		if(StringUtils.isNotEmpty(rebate.getXmbzj()))
		{
			Map<String, Object> paraMap2 = new HashMap<String, Object>();
			paraMap2.put("voucherCode","%"+rebate.getXmbzj()+"%");
			paraMap2.put("applyStatus","0");
			
			List<PaymentVoucherHis> lp=paymentVoucherHisService.findPaymentVoucherHis(paraMap2);
			if(lp.size()>0){
				paraMap.put("slbh", "%"+lp.get(0).getOrderId()+"%");
			}
		}
		pagination =paymentItemHisService.findByPage(pagination, paraMap);
		int totalcount = pagination.getTotalCount();
		List<PaymentItemHis> list = pagination.list;
		for(PaymentItemHis p:list)
		{
			Rebate re = new Rebate();
			re.setSlbh(p.getSlbh());
			re.setDwmc(p.getDwmc());
			re.setCsmj(p.getCsmj());
			re.setPtyjmj(p.getPtyjmj());
			re.setPtyjje(p.getPtyjje());
			re.setXmbzj(p.getXmbzj());
			re.setXmmc(p.getXmmc());
			Map<String, Object> dd = new HashMap<String, Object>();
			dd.put("slbh", re.getSlbh());
			dd.put("applyStatus","0");
			List<PaymentVoucherHis> lpdd=paymentVoucherHisService.findPaymentVoucherHis(dd);
			if(null!=lpdd&&lpdd.size()>0){
				re.setYbjksbh(lpdd.get(0).getVoucherCode());
			}
			rabateList.add(re);
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|ptyjmj|ptyjje|xmbzj|dwmc|slbh|csmj|xmmc|ybjksbh|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = rebateService.findByPage(pagination, paraMap);
		pagination.list = rabateList;
		pagination.setTotalCount(totalcount);
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != rebate)&&(null != rebate.getId()))
			rebate = rebateService.getById(rebate.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			rebate.setDeptId(this.getLoginUserDepartmentId());
			rebate.setDelFlag(0);
			rebateService.save(rebate);
		}else{
			rebateService.update(rebate);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != rebate)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到rebate中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			rebateService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Rebate getRebate(){
		return this.rebate;
	}

	public void setRebate(Rebate rebate){
		this.rebate = rebate;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
}
