package com.jshx.paymentLq.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentLq.entity.Paymentlq;
import com.jshx.paymentLq.dao.PaymentlqDao;

@Component("paymentlqDao")
public class PaymentlqDaoImpl extends BaseDaoImpl implements PaymentlqDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentlqByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentlq(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentlqByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Paymentlq getById(String id)
	{
		return (Paymentlq)this.getObjectById(Paymentlq.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Paymentlq paymentlq)
	{
		paymentlq.setId(null);
		this.saveOrUpdateObject(paymentlq);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Paymentlq paymentlq)
	{
		this.saveOrUpdateObject(paymentlq);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Paymentlq.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Paymentlq paymentlq = (Paymentlq)this.getObjectById(Paymentlq.class, id);
		paymentlq.setDelFlag(1);
		this.saveObject(paymentlq);
	}
}
