package com.jshx.paymentItemPending.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import com.jshx.fstzs.dao.FstzsXmDao;
import com.jshx.fstzs.entity.FstzsXm;
import com.jshx.kpsjgl.dao.KpsjglDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jktzs.dao.JktzsDao;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.paymentItemPending.dao.PaymentItemPendingDao;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.xmxxb.dao.XmxxbDao;
import com.jshx.xmxxb.entity.Xmxxb;

@Service("paymentItemPendingService")
public class PaymentItemPendingServiceImpl extends BaseServiceImpl implements PaymentItemPendingService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	private PaymentItemPendingDao paymentItemPendingDao;
	@Autowired() 
	private XmxxbDao xmxxbDao;
	@Autowired() 
	private JktzsDao jktzsDao;

	@Autowired()
	private KpsjglDao kpsjglDao;

	@Autowired()
	private FstzsXmDao fstzsXmDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentItemPendingDao.findByPage(page, paraMap);
	}
	
	/**
	 * 不分页查询
	 * @param paraMap
	 * @return
	 */
	@Transactional
	public List<PaymentItemPending> findPaymentItemPending(Map<String, Object> paraMap) {
		return paymentItemPendingDao.findPaymentItemPending(paraMap);
	}

	/**
	 * 根据受理编号查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemPending getByOrderId(String orderId) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("slbh", orderId);
		PaymentItemPending paymentItemPending = (PaymentItemPending)paymentItemPendingDao.findObjectByFieldsMap(PaymentItemPending.class, paraMap);
		return paymentItemPending;
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemPending getById(String id)
	{
		return paymentItemPendingDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentItemPending paymentItemPending)
	{
		paymentItemPendingDao.save(paymentItemPending);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentItemPending paymentItemPending)
	{
		paymentItemPendingDao.update(paymentItemPending);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentItemPendingDao.findPaymentItemPending(paraMap);
		
		paymentItemPendingDao.removeAll(objects);
	}
	
	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	@Transactional
	public void delete(String id) {
		paymentItemPendingDao.removeObjectById(PaymentItemPending.class, id);
		
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    paymentItemPendingDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	public void czgl(PaymentItemPending dj, Xmxxb xmb, Jktzs jk) {
     try {
    		Map<String, Object> paraMap = new HashMap<String, Object>();
			if ((null != xmb.getSlbh()) && (0 < xmb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xmb.getSlbh().trim() + "%");
			}
			List<PaymentItemPending> listpa=paymentItemPendingDao.findPaymentItemPending(paraMap);
			List<Jktzs> listjk=jktzsDao.findJktzs(paraMap);
			if(listpa.size()>0){
				for (PaymentItemPending pa : listpa) {
					paymentItemPendingDao.delete(pa.getId());
				}
			}
			if(listjk.size()>0){
				for (Jktzs jktzs : listjk) {
					jktzsDao.delete(jktzs.getId());
				}
			}
 		jk.setDelFlag(0);
		jk.setSlbh(dj.getSlbh());
		jk.setXxbbh(xmb.getXxylb());
		jk.setXmbzj(xmb.getId());
		if(!"".equals(dj.getDwmc())&&null!=dj.getDwmc()){
			jk.setDwmc(dj.getDwmc());
		}
			
		jk.setXmmc(dj.getXmmc());
	
		jk.setXmdd(xmb.getJsdd());
		jk.setCkbh(xmb.getCkbh());
		jk.setDwdm(xmb.getDwdm());
		jk.setGhxkz(xmb.getXkzh());
		jk.setZjzmj(dj.getCsmj());
		jk.setCsptf(xmb.getSjcsje());
		jk.setJfmj(dj.getPtyjmj());
		jk.setJfje(dj.getPtyjje());
		jk.setMjmj(dj.getPtymmj());
		jk.setMjje(dj.getPtymje());
		jk.setLianxiren(xmb.getLianxiren());
		jk.setPhone(xmb.getPhone());
		if("1".equals(dj.getIsqitalx())){
		jk.setXqtyj(dj.getXqyjje());
		jk.setRfyj(dj.getRfyjje());
		jk.setByyj(dj.getByyjje());
		jk.setIsqtfy("1");
		}else{
			jk.setIsqtfy("0");
		}
		if("1".equals(xmb.getIsdikou())){
			jk.setDkslh(xmb.getDkslbh());
			jk.setDkmj(dj.getDkmj());
		}
		jk.setDycs("0");
//		this.save(dj);
		paymentItemPendingDao.save(dj);
		jktzsDao.save(jk);
		xmxxbDao.update(xmb);
		
	} catch (Exception e) {
		e.printStackTrace();
		//TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();

	  }		
	}
	@Transactional
	public void zjdyxg(PaymentItemPending dj, Xmxxb xmb, Jktzs jk) {
		try {
			jk.setDelFlag(0);
			jk.setSlbh(dj.getSlbh());
			jk.setXxbbh(xmb.getXxylb());
			jk.setXmbzj(xmb.getId());
			if(!"".equals(dj.getDwmc())&&null!=dj.getDwmc()){
				jk.setDwmc(dj.getDwmc());
			}
			jk.setXmmc(dj.getXmmc());
			jk.setXmdd(xmb.getJsdd());
			jk.setCkbh(xmb.getCkbh());
			jk.setDwdm(xmb.getDwdm());
			jk.setGhxkz(xmb.getXkzh());
			jk.setZjzmj(dj.getCsmj());
			jk.setCsptf(xmb.getSjcsje());
			jk.setJfmj(dj.getPtyjmj());
			jk.setJfje(dj.getPtyjje());
			jk.setMjmj(dj.getPtymmj());
			jk.setMjje(dj.getPtymje());
			jk.setLianxiren(xmb.getLianxiren());
			jk.setPhone(xmb.getPhone());
			if("1".equals(dj.getIsqitalx())){
				jk.setXqtyj(dj.getXqyjje());
				jk.setRfyj(dj.getRfyjje());
				jk.setByyj(dj.getByyjje());
				jk.setIsqtfy("1");
			}else{
				jk.setIsqtfy("0");
				
			}
			jk.setDycs("0");
			this.save(dj);
			//保存项目到非税通知书表
			FstzsXm xm = new FstzsXm();
			xm.setXmxxb(xmb);
			//获取收款人信息保存到项目中
			HashMap<String, Object> param = new HashMap<>();
			param.put("gllb","001");
			xm.setKpsjgl(kpsjglDao.findFirst(param));
			xm.setDelFlag(0);
			xm.setStatus(0);

			xm.setJsdwmc(dj.getDwmc());
			xm.setGcxmmc(dj.getXmmc());
			xm.setSlbh(dj.getSlbh());
			xm.setYjje(dj.getZyjje());
			fstzsXmDao.save(xm);

			jktzsDao.save(jk);

			
		} catch (Exception e) {
			e.printStackTrace();
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			
		}		
	}

	
}
