package com.jshx.paymentItemDelay.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemDelay.dao.PaymentItemDelayDao;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;

@Service("paymentItemDelayService")
public class PaymentItemDelayServiceImpl extends BaseServiceImpl implements PaymentItemDelayService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentItemDelayDao")
	private PaymentItemDelayDao paymentItemDelayDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentItemDelayDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemDelay getById(String id)
	{
		return paymentItemDelayDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentItemDelay paymentItemDelay)
	{
		paymentItemDelayDao.save(paymentItemDelay);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentItemDelay paymentItemDelay)
	{
		paymentItemDelayDao.update(paymentItemDelay);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentItemDelayDao.findPaymentItemDelay(paraMap);
		
		paymentItemDelayDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    paymentItemDelayDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<PaymentItemDelay> findall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return paymentItemDelayDao.findPaymentItemDelay(paraMap);
	}

	@Override
	public PaymentItemDelay getBySlbh(String slbh) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", slbh);
		PaymentItemDelay paymentItemDelay = (PaymentItemDelay) paymentItemDelayDao.findObjectByFieldsMap(PaymentItemDelay.class, paraMap);
		return paymentItemDelay;
	}
}
