package com.jshx.mjyj.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.mjyj.dao.MjyjDao;
import com.jshx.mjyj.entity.Mjyj;
import com.jshx.mjyj.service.MjyjService;

@Service("mjyjService")
public class MjyjServiceImpl extends BaseServiceImpl implements MjyjService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("mjyjDao")
	private MjyjDao mjyjDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return mjyjDao.findByPage(page, paraMap);
	}
	
	/**
	 * 根据面积依据类型查询数据
	 * @param type
	 * @return
	 */
	public Mjyj findByTypeCode(String type){
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("bianhao", type);
		return (Mjyj)mjyjDao.findObjectByFieldsMap(Mjyj.class, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Mjyj getById(String id)
	{
		return mjyjDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Mjyj mjyj)
	{
		mjyjDao.save(mjyj);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Mjyj mjyj)
	{
		mjyjDao.update(mjyj);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=mjyjDao.findMjyj(paraMap);
		
		mjyjDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    mjyjDao.deleteWithFlag(id);
			}
		}
	}
}
