package com.jshx.jfzm.web;

import com.google.gson.Gson;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.entity.RfxmSfxx;
import com.jshx.rfxm.service.RfxmService;
import com.jshx.rfxm.service.RfxmSfxxService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.wwjdclinfo.service.WwjdclinfoService;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.service.WwsqysService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.TextUtils;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import sun.misc.BASE64Decoder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;

public class JfzmAction extends BaseAction {

    @Autowired
    private JktzsService jktzsService;
    @Autowired
    private SpjlbService spjlbService;

    @Autowired
    RfxmService rfxmService;
    @Autowired
    RfxmSfxxService rfxmSfxxService;
    @Autowired
    XmxxbService xmxxbService;
    @Autowired
    PaymentItemHisService paymentItemHisService;
    @Autowired
    private WwsqysService wwsqysService;
    @Autowired
    private WwjdclinfoService wwjdclinfoService;

    private List<Wwjdclinfo> wwjdclinfos = new ArrayList<>();


    @Autowired
    private ZsdwService zsdwService;

    /**
     * 分页信息
     */
    private Pagination pagination;

    Rfxm rfxm = new Rfxm();
    Xmxxb xmxxb = new Xmxxb();
    PaymentItemHis paymentItemHis = new PaymentItemHis();

    String id;



    /**
     * 缴费证明列表
     * @throws Exception
     */
    public void list() throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();

        if(pagination==null)
            pagination = new Pagination(this.getRequest());

        if(null != rfxm){

            //设置查询条件，开发人员可以在此增加过滤条件
            /**
             *	    			"rfxm.xkzh": $("#xkzh").val(),
             * 					"rfxm.zslxdbh": $("#zslxdbh").val(),
             * 					"rfxm.xxylbbh": $("#xxylbbh").val(),
             * 					"rfxm.xmbh": $("#xmbh").val(),
             * 					"rfxm.jsdwmc": $("#jsdwmc").val(),
             * 					"rfxm.gcxmmc": $("#gcxmmc").val(),
             * 					"rfxm.paymentLink": $("#paymentLink").val(),
             * 					"rfxm.isRfyz": $("#isRfyz").val(),
             * 					"rfxm.mjyj": $("#mjyj").val()
             */
            if (!TextUtils.isEmpty(rfxm.getXkzh())){
                paraMap.put("xkzh", "%" + rfxm.getXkzh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getZslxdbh())){
                paraMap.put("zslxdbh", "%" + rfxm.getZslxdbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getXxylbbh())){
                paraMap.put("xxylbbh", "%" + rfxm.getXxylbbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getXmbh())){
                paraMap.put("xmbh", "%" + rfxm.getXmbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getJsdwmc())){
                paraMap.put("jsdwmc", "%" + rfxm.getJsdwmc().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getGcxmmc())){
                paraMap.put("gcxmmc", "%" + rfxm.getGcxmmc().trim() + "%");
            }

            if (rfxm.getPaymentLink() != null && rfxm.getPaymentLink() > 0){
                paraMap.put("paymentLink", rfxm.getPaymentLink());
            }
            if (rfxm.getIsRfyz() != null){
                paraMap.put("isRfyz", rfxm.getIsRfyz());
            }
            if (!TextUtils.isEmpty(rfxm.getMjyj())){
                paraMap.put("mjyj", rfxm.getMjyj().trim());
            }

        }
        if(!this.getLoginUser().getIsSuperAdmin()){
            String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
            paraMap.put("dwdm", dwdm);
        }

        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
        Map<String, String> codeMap = new HashMap<String, String>();
        //此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

        config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
        pagination = rfxmService.findByPage(pagination, paraMap);
        for (int i = 0; i < pagination.list.size(); i++) {
            Rfxm r = (Rfxm) pagination.list.get(i);
            if(r.getPaymentHisId() != null) {
                PaymentItemHis pih = paymentItemHisService.getById(r.getPaymentHisId());
                Map<String, Object> pm = new HashMap<>();
                pm.put("rfxmid", r.getId());
                List<RfxmSfxx> rfxmSfxxList = rfxmSfxxService.findRfxmSfxx(pm);
                RfxmSfxx sfxx = rfxmSfxxList == null || rfxmSfxxList.size() == 0 ? null : rfxmSfxxList.get(0);

                // 1,判断是否显示同步按钮  2，判断是否置灰
                r.setShowTb(r.getIsSl() != 1 ? 1 : 0);//房改办,竖联,不显示施工许可

                try {
                    r.setShowYb(Double.parseDouble(pih.getPtyjje()) != 0 ? 1 : 0);//配套费=0,不显示一般缴费证明
                } catch (Exception e) {

                }

                if(r.getIsRfyz() != null && r.getIsRfyz() == 1 && (r.getIsTb() == null || r.getIsTb() != 1)) {//人防用章后可以同步
                    r.setEnableTb(1);
                } else if(r.getIsSbj() != 1) {//非市本级
                    r.setEnableTb(0);
                } else if(sfxx != null && sfxx.getTqjn() != null &&  sfxx.getTqjn() == 1 && sfxx.getStatus() != 0 && (r.getIsTb() == null || r.getIsTb() != 1)) {//显示补录时可以同步
                    r.setEnableTb(1);
                } else {
                    r.setEnableTb(0);
                }
            }
        }

        convObjectToJson(pagination, config);
    }

    /**
     * 同步缴费证明
     */
    public void sync() {

    }

    /**
     * 打印缴费证明时，查询所需要的数据
     */
    public String print() {
        rfxm = rfxmService.getById(id);
        xmxxb = xmxxbService.getById(rfxm.getXmxxbId());
        paymentItemHis = paymentItemHisService.getById(rfxm.getPaymentHisId());
        return VIEW;
    }

    public String fujian() {
        xmxxb = xmxxbService.getBySlbh(xmxxb.getSlbh());
        Map map = new HashMap();
        map.put("xxylb",xmxxb.getXxylb());
        map.put("fjqm","一般缴款书");
        Pagination  pagination1 = wwjdclinfoService.findByPage(new Pagination(1,0),map);
        wwjdclinfos = pagination1.getListOfObject();
        return EDIT;
    }

    private File file; //文件上传
    private String fileBase64; //文件上传
    private String ids;

    /**
     * 缴费凭证同步
     * @throws Exception
     */
    public void jfpztongbu() throws Exception {
        saveJfzmPng();
        xxsyncPz(xmxxb);
    }

    /**
     * 线下项目同步凭证方法
     */
    private void xxsyncPz(Xmxxb xmxxb) throws Exception
    {
        //根据信息一览表id查询办件材料表的信息
        Map<String,Object> paraMap = new HashMap<>();
        paraMap.put("xxylb",xmxxb.getXxylb());
        Pagination pagination = wwjdclinfoService.findByPage(new Pagination(1,0),paraMap);
        List<Wwjdclinfo> listOfObject = pagination.getListOfObject();
        if(CollectionUtils.isEmpty(listOfObject))
        {
            this.getResponse().getWriter().println("{\"result\":\"false\",\"info\":\"结果件未上传！\"}");
            return ;
        }
        Wwjdclinfo wwjdclinfo2 = null;
        String flag2 = null ;
        for(Wwjdclinfo wwjdclinfo : listOfObject)
        {
            if("缴费凭证".equals(wwjdclinfo.getFjqm()))
            {
                flag2 =	wwjdclinfo.getIsSync();
                wwjdclinfo2 = wwjdclinfo;
            }
        }
        if(wwjdclinfo2 == null)
        {
            this.getResponse().getWriter().println("{\"result\":\"false\",\"info\":\"缴费凭证未上传！\"}");
            return ;
        }

        PaymentItemHis paymentItemHis = paymentItemHisService.getByXmbId(xmxxb.getId());

        Map<String,String> map = new HashMap();

        //凭证同步
        map.put("wwsqbh",wwjdclinfo2.getWwsqbh());
//		map.put("xxylb",wwjdclinfo2.getXxylb());
        map.put("fjqm",wwjdclinfo2.getFjqm());
        map.put("Scwjm",wwjdclinfo2.getScwjm());
        map.put("scdz",wwjdclinfo2.getScdz());

        //电子监管号
        map.put("dzjgh",paymentItemHis.getECN());
        map.put("jfpzbh",paymentItemHis.getZslxdbh());
        map.put("xmslbh",paymentItemHis.getSlbh());
//		map.put("jfje",paymentItemHis.getZyjje());//缴费金额
//		map.put("mjje",paymentItemHis.getZymje());//免缴金额

        map.put("xxylb",xmxxb.getXxylb());
        map.put("fgwxmbh",xmxxb.getLxpw());
        map.put("jsdw",xmxxb.getJsdw());
        map.put("xmmc",xmxxb.getXmmc());
        map.put("gcxmdz",xmxxb.getJsdd());
        map.put("szmj",xmxxb.getZjsmj());
        map.put("bz",xmxxb.getBeizhu());

        map.put("jfpzlxdh",xmxxb.getPhone());
        map.put("jfpzlxr",xmxxb.getLianxiren());
        map.put("jddh","000000");
        map.put("jfpzdyrq",paymentItemHis.getUpdateTime().toString());
        map.put("ghxmbh",xmxxb.getXmbh()); //规划项目编号


        //审核过程记录
        Map<String, Object> jkjlb = new HashMap<String, Object>();
        jkjlb.put("xxbbh", xmxxb.getXxylb());
        List<Spjlb> ls=spjlbService.findSpjlball(jkjlb);
        String csr="";//初审人
        String csyj="";//初审意见
        String fhr="";//复核人
        String fhyj="";//复核意见
        String yjfy="";//应缴金额
        if(null!=ls&&ls.size()>0){
            csr=ls.get(0).getCsr();
            csyj=ls.get(0).getCsbz();
            fhr=ls.get(0).getFhr();
            fhyj=ls.get(0).getFhbz();
            Map<String, Object> jktzmap1 = new HashMap<String, Object>();
            jktzmap1.put("slbh", ls.get(0).getSlbh());
            List<Jktzs> jklist=jktzsService.findByAll(jktzmap1);
            if(null!=jklist&&jklist.size()>0){
                Jktzs jk = jklist.get(0);
                yjfy=jk.getJfje();
                map.put("ghxkzbh",jk.getGhxkz()); //规划许可证编号
                map.put("jfmj",jk.getJfmj()); //缴费面积
                map.put("jfje",jk.getJfje()); //缴费金额
                map.put("mjmj",jk.getMjmj()); //免缴面积
                map.put("mjje",jk.getMjje()); //免缴金额
                map.put("qtfy",jk.getRfyj()); //其他费用
                map.put("jktzsbh",jk.getDzbh());//缴款通知书编号
            }


        }
        map.put("csr", csr);
        map.put("csyj", csyj);
        map.put("fhr", fhr);
        map.put("fhyj", fhyj);
        map.put("yjfy", yjfy);
        if("001".equals(xmxxb.getMjyj())||"005".equals(xmxxb.getMjyj()))
        {
            map.put("isneed","yes");
        }else
        {
            map.put("isneed","no");
        }

        map.put("key",String.valueOf((new Date().getTime()*6+1)/7));
        map.put("method","xxsyncpz");
        String dwdm = "";
        if (!this.getLoginUser().getIsSuperAdmin())
        {
            dwdm =StringUtil.isEmpty(xmxxb.getDwdm())? zsdwService.getDwdm(this.getLoginUserDepartmentId()):xmxxb.getDwdm();
        }
//		String result3 =  CommonAction.send2wwSGXK(xmxxb,null,dwdm,map);//arvin1122
        String result3 = "true";
//		String result3 = com.jshx.module.admin.web.action.CommonAction.send2ww(map,null);
        if(StringUtil.isEmpty(result3)||"false".equals(result3)) {

            this.getResponse().getWriter().println("{\"result\":\"false\",\"info\":\"同步失败！\"}");
            return;
        }
        else if("true".equals(result3))
        {
            //更新表字段isSync为yes
            wwjdclinfo2.setIsSync("yes");
            wwjdclinfoService.update(wwjdclinfo2);
			/*if(paymentItemHis.getYzsFlag() == 2){
				savePaymentVerification(xmxxb, paymentItemHis);
			}*/
            HashMap<String, Object> rfxmParam = new HashMap<>();
            rfxmParam.put("paymentHisId",paymentItemHis.getId());
            List<Rfxm> rfxmList = rfxmService.findRfxm(rfxmParam);
            if(rfxmList != null && rfxmList.size() > 0) {//同步成功记录下，不允许再次同步了
                Rfxm rfxm = rfxmList.get(0);
                rfxm.setIsTb(1);
                rfxmService.update(rfxm);
            }
            this.getResponse().getWriter().println("{\"result\":\"true\",\"info\":\"查询成功\"}");
            return ;
        }
    }


    public String saveJfzmPng() throws Exception
    {
        xmxxb = xmxxbService.getByXxylb(xmxxb.getXxylb());
        String fileName = "缴费凭证.png";
        String fileName1 = "";
        if(xmxxb != null && !TextUtils.isEmpty(xmxxb.getSlbh()) && xmxxb.getSlbh().length() > 6) {
            fileName= "缴费凭证_" + xmxxb.getSlbh().substring(0,4) +
                    xmxxb.getSlbh().substring(xmxxb.getSlbh().length() - 3) +
                    xmxxb.getSlbh().substring(xmxxb.getSlbh().length() - 5,xmxxb.getSlbh().length() - 3) + ".png";
        }
        String rubiaopath ="";
        //id : uploadName;ids:uploadShowName
        String ids = "缴费凭证";
        // 上传文件
        String path = SysPropertiesUtil.jdlj(this.getRequest())
                + File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator;
        rubiaopath = "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator+fileName;
        rubiaopath = rubiaopath.replaceAll("\\\\", "/").trim();
        path = path.replaceAll("\\\\", "/").trim();
        fileName1 = FileUtils.uploadFileStr(fileBase64,fileName, path);
        Wwjdclinfo wwjdclinfo = new Wwjdclinfo();
        wwjdclinfo.setDeptId(this.getLoginUserDepartmentId());
        wwjdclinfo.setDelFlag(0);


//			List<Wwsqys> ls = wwsqysService.findxxylb(xmxxb.getXxylb());
        if(xmxxb != null && "9".equals(xmxxb.getHfsz()))
        {
            List<Wwsqys> wwsqyss = wwsqysService.findxxylb(xmxxb.getXxylb());
            wwjdclinfo.setWwsqbh(wwsqyss.get(0).getWwsqbh());
        }
        else
        {
            wwjdclinfo.setWwsqbh("xxsbxm");
        }

        wwjdclinfo.setScdz(rubiaopath);
        wwjdclinfo.setScwjm(fileName);
        wwjdclinfo.setFjqm(ids);
//		wwjdclinfo.setWwsqbh(wwsqys.getWwsqbh());
        wwjdclinfo.setXxylb(xmxxb.getXxylb());
        //查询表中是否存在，若存在则覆盖
        Map<String, Object> paraMap = new HashMap<String, Object>();
        Pagination pagination =new Pagination(1,100);
        paraMap.put("xxylb",xmxxb.getXxylb());
        paraMap.put("fjqm",ids);
        pagination = wwjdclinfoService.findByPage(pagination,paraMap);
        List<Wwjdclinfo> wwjdclinfos = pagination.getListOfObject();
        if(CollectionUtils.isEmpty(wwjdclinfos))
        {
            wwjdclinfoService.save(wwjdclinfo);
        }
        else
        {
            Wwjdclinfo wwjdclinfo1 = wwjdclinfos.get(0);
            wwjdclinfo1.setFjqm(ids);
            wwjdclinfo1.setScwjm(fileName);
            wwjdclinfo1.setScwjm(fileName);
            wwjdclinfo1.setScdz(rubiaopath);
            wwjdclinfoService.update(wwjdclinfo1);
        }
        return RELOAD;
    }

    /**
     * 凭证上传
     * 先缓存至服务器
     */
    public String fujiantongbu() throws Exception
    {
        String fileName1="";
        String rubiaopath ="";
        //id : uploadName;ids:uploadShowName
        String ids = "一般缴款书";
        //TODO 上传文件
        String path = SysPropertiesUtil.jdlj(this.getRequest())
                + File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator;
        rubiaopath = "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator+id;
        rubiaopath = rubiaopath.replaceAll("\\\\", "/").trim();
        path = path.replaceAll("\\\\", "/").trim();
        fileName1 = FileUtils.uploadFile(file,id, path);
        Wwjdclinfo wwjdclinfo = new Wwjdclinfo();
        wwjdclinfo.setDeptId(this.getLoginUserDepartmentId());
        wwjdclinfo.setDelFlag(0);

        xmxxb = xmxxbService.getByXxylb(xmxxb.getXxylb());
//			List<Wwsqys> ls = wwsqysService.findxxylb(xmxxb.getXxylb());
        if(xmxxb != null && "9".equals(xmxxb.getHfsz()))
        {
            List<Wwsqys> wwsqyss = wwsqysService.findxxylb(xmxxb.getXxylb());
            wwjdclinfo.setWwsqbh(wwsqyss.get(0).getWwsqbh());
        }
        else
        {
            wwjdclinfo.setWwsqbh("xxsbxm");
        }

        wwjdclinfo.setScdz(rubiaopath);
        wwjdclinfo.setScwjm(id);
        wwjdclinfo.setFjqm(ids);
//		wwjdclinfo.setWwsqbh(wwsqys.getWwsqbh());
        wwjdclinfo.setXxylb(xmxxb.getXxylb());
        //查询表中是否存在，若存在则覆盖
        Map<String, Object> paraMap = new HashMap<String, Object>();
        Pagination pagination =new Pagination(1,100);
        paraMap.put("xxylb",xmxxb.getXxylb());
        paraMap.put("fjqm",ids);
        pagination = wwjdclinfoService.findByPage(pagination,paraMap);
        List<Wwjdclinfo> wwjdclinfos = pagination.getListOfObject();
        if(CollectionUtils.isEmpty(wwjdclinfos))
        {
            wwjdclinfoService.save(wwjdclinfo);
        }
        else
        {
            Wwjdclinfo wwjdclinfo1 = wwjdclinfos.get(0);
            wwjdclinfo1.setFjqm(ids);
            wwjdclinfo1.setScwjm(id);
            wwjdclinfo1.setScdz(rubiaopath);
            wwjdclinfoService.update(wwjdclinfo1);
        }
        return RELOAD;
    }


    public String jfzm_view() {
        return print();
    }

    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Rfxm getRfxm() {
        return rfxm;
    }

    public void setRfxm(Rfxm rfxm) {
        this.rfxm = rfxm;
    }

    public Xmxxb getXmxxb() {
        return xmxxb;
    }

    public void setXmxxb(Xmxxb xmxxb) {
        this.xmxxb = xmxxb;
    }

    public PaymentItemHis getPaymentItemHis() {
        return paymentItemHis;
    }

    public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
        this.paymentItemHis = paymentItemHis;
    }

    public List<Wwjdclinfo> getWwjdclinfos() {
        return wwjdclinfos;
    }

    public void setWwjdclinfos(List<Wwjdclinfo> wwjdclinfos) {
        this.wwjdclinfos = wwjdclinfos;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileBase64() {
        return fileBase64;
    }

    public void setFileBase64(String fileBase64) {
        this.fileBase64 = fileBase64;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }
}
