package com.jshx.hissffzrjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissffzrjlb.entity.Hissffzrjlb;
import com.jshx.hissffzrjlb.dao.HissffzrjlbDao;

@Component("hissffzrjlbDao")
public class HissffzrjlbDaoImpl extends BaseDaoImpl implements HissffzrjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHissffzrjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHissffzrjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHissffzrjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissffzrjlb getById(String id)
	{
		return (Hissffzrjlb)this.getObjectById(Hissffzrjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hissffzrjlb hissffzrjlb)
	{
		hissffzrjlb.setId(null);
		this.saveOrUpdateObject(hissffzrjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hissffzrjlb hissffzrjlb)
	{
		this.saveOrUpdateObject(hissffzrjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hissffzrjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hissffzrjlb hissffzrjlb = (Hissffzrjlb)this.getObjectById(Hissffzrjlb.class, id);
		hissffzrjlb.setDelFlag(1);
		this.saveObject(hissffzrjlb);
	}
}
