package com.jshx.fstzs.web;

import com.alibaba.fastjson.JSONObject;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.fstzs.fsutil.FsRequest;
import com.jshx.fstzs.fsutil.bean.FsResult;
import com.jshx.fstzs.fsutil.bean.JkztResp;
import com.jshx.fstzs.service.FstzsService;
import com.jshx.jkfsjlb.entity.Jkfsjlb;
import com.jshx.jkfsjlb.service.JkfsjlbService;
import com.jshx.tbshxk.entity.Tbshxk;
import com.jshx.tbshxk.service.TbshxkService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
public class FstzsDsrw {

    @Autowired
    FstzsService fstzsService;

    //每天11，12，13点刷新缴费状态
    @Scheduled(cron = "0 0 11,12,13 * * ?")
    public void queryJfzt() {
        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("status",new ArrayList<Integer>(){{
            add(1);//已激活
        }});

        //1，查询全部未激活的信息
        List<Fstzs> list = fstzsService.findList(paraMap);
        list.stream().map(i-> {
            //2，循环接口请求缴费状态
            FsResult<JkztResp> jiaokuanzt = FsRequest.jiaokuanzt(i);
            if(jiaokuanzt.success) {
                i.setStatus(3);//已缴款
                i.setIsJk(1);
                i.setJkTime(jiaokuanzt.data.confirmDate);
                i.setJkqd(jiaokuanzt.data.paymentChannel);
            } else {

            }
            return i;
        }).forEach(i-> fstzsService.update(i));
    }
}