package com.jshx.fstzs.fsutil.bean;

import com.google.gson.annotations.SerializedName;

public class FsResp<T> {

    /**
     * 错误返回:
     * {"error_message":{"error_code":"0003","error_msg":"未找到对应的票据批次,票据种类:00010302票据批次:32010122"}}
     *
     * 成功返回：
     * {"message":{"pay_code":"32010022090000118237","serial_number":"1669705873720","create_time":"20221129151116215"}}
     */
    @SerializedName("error_message")
    public FsError errorMessage;

    public T message;


    public String getErrorMsg() {
        if(errorMessage != null) {
            return errorMessage.errorCode + "：" + errorMessage.errorMsg;
        }
        return "未知错误";
    }

}
