package com.jshx.fstzs.fsutil;

import com.google.gson.Gson;
import com.jshx.core.utils.CodeUtil;
import com.jshx.core.utils.SysPropertiesUtil;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 构建请求参数
 */
public class ParamsUtil {

    /**
     * 这里构建统一参数
     * @param method
     * @param data   接口所需参数
     * @return
     */
    public static Map<String,String> getParams(String method,Map<String,Object> data) {
        Map<String,String> params = new HashMap<>();
        params.put("method",method);
        params.put("app_id", SysPropertiesUtil.getProperty("fs-appid"));
        params.put("format","json");
        params.put("datetime",new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        params.put("version",SysPropertiesUtil.getProperty("fs-version"));
        params.put("region_code",SysPropertiesUtil.getProperty("fs-qhbm"));//区划？外部传？
        params.put("agency_code",SysPropertiesUtil.getProperty("fs-dwbm"));//单位
        params.put("encryption","0");//不加密
        params.put("message_id",System.currentTimeMillis() + "");//每次请求生成一个唯一请求编号
        if(data != null && data.size() > 0) {
            //第一步，message外面套一层
            Map<String,Object> message = new HashMap<>();
            message.put("message",data);
            //第二步，message进行base64加密
            byte[] msgEn = CodeUtil.base64Encode(new Gson().toJson(message).getBytes(StandardCharsets.UTF_8));
            //第三步，放回接口参数内
            params.put("message",new String(msgEn));//接口需要的参数
        }
        SecurityUtils.security(params);
        return params;
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("key","value");
        Map<String, String> hello = getParams("hello", map);
        System.out.println(new Gson().toJson(hello));
    }
}
