package com.jshx.fstzs.fsutil;


import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jshx.core.utils.CodeUtil;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.fstzs.fsutil.bean.*;
import com.jshx.http.HttpclientUtil;
import com.neusoft.egov.utils.TextUtils;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 非税系统请求
 */
public class FsRequest {

    private static String getProp(String key) {
        return SysPropertiesUtil.getProperty(key);
    }
    private static String request(String method,Map<String, Object> data) {
        System.out.println("method：" + method);
        System.out.println("param：" + new Gson().toJson(data));
        Map<String, String> params = ParamsUtil.getParams(method, data);
        try {
            String post = HttpclientUtil.post(getProp("fs-url"), params);

            if(post != null) {
                String resp = new String(CodeUtil.base64Decode(post),"utf-8");
                System.out.println("resp：" + resp);
                return resp;
            }
            return post;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    private static String test() {
        Map<String, Object> params = new HashMap<>();
        params.put("place_code","001");
        return request("basic.bills.get",params);
    }

    /**
     *
     * @param fstzs     非税缴费对象
     */
    public static FsResult<KjjksResp> jihuo(Fstzs fstzs) {
        Map<String,Object> map = new HashMap<>();
        map.put("serial_number", fstzs.getLsh());//流水号
        map.put("place_code",getProp("fs-kpdbm"));//开票点编码
        map.put("bill_code",getProp("fs-billcode"));//票据种类编码
        map.put("date",new SimpleDateFormat("yyyy-MM-dd").format(new Date()));//日期: YYYY-MM-DD
        map.put("payer_name",fstzs.getJkr());//缴款人
        map.put("payer_tel",fstzs.getFstzsXm().getMobile());//缴款人手机号
//        map.put("payer_acc_name","???");//付款人户名
        map.put("payer_no",fstzs.getFstzsXm().getZhanghao());//付款人账号(划缴时，必填)
        map.put("payer_bank",fstzs.getFstzsXm().getKhh());//付款人开户银行(划缴时，必填)
        /**
         * 账户给定方式:
         * 1财政设置
         * 2单位指定
         * 3子账号（不支持单位独立部署）
         */
        map.put("acc_assign_type","1");
        map.put("total_amt",fstzs.getYjje());//合计金额
        map.put("author",fstzs.getJksJbr());//开票人
        map.put("memo",fstzs.getFstzsXm().getBeizhu());//备注

        Map<String,String> mapDatail = new HashMap<>();
        mapDatail.put("item_code",getProp("fs-sfxmbh"));
        mapDatail.put("std",fstzs.getYjje());//收费标准
        mapDatail.put("number","1");//数量
        mapDatail.put("amt",fstzs.getYjje());//金额
        List<Map<String,String>> list = new ArrayList<>();
        list.add(mapDatail);
        map.put("item_details",list);

        try {
            String request = request("paybook.e.issue.js.do", map);
            if(TextUtils.isEmpty(request)) {
                return FsResult.fail("网络异常,请重试！");
            }
            FsResp<KjjksResp> resp = new Gson().fromJson(request, new TypeToken<FsResp<KjjksResp>>() {
            }.getType());
            if(resp.errorMessage != null) {
                return FsResult.fail(resp.errorMessage.errorMsg);
            }
            return new FsResult<>(resp.message);
        } catch (Exception e) {
            System.out.println("激活请求异常！！");
            return FsResult.fail("激活请求异常！！" + e.getMessage());

        }

    }

    /**
     * 作废电子缴款书
     * {"error_message":{"error_code":"0001","error_msg":"缴款书已缴款确认，不能作废!"}}
     * @param fstzs
     */
    public static FsResult<Boolean> zuofei(Fstzs fstzs) {
        Map<String,Object> map = new HashMap<>();
        map.put("pay_code",fstzs.getJkm());
        String request = request("paybook.e.invalidate.do", map);
        if(TextUtils.isEmpty(request)) {
            return FsResult.fail("网络异常,请重试！");
        }
        FsResp<CaozuoResp> resp = new Gson().fromJson(request, new TypeToken<FsResp<CaozuoResp>>() {
        }.getType());
        if(resp.message != null && "0000".equals(resp.message.succCode)) {
            return new FsResult<>(true);
        }
        return FsResult.fail(resp.errorMessage.errorMsg);
    }

    /**
     * 查询缴款书状态，是否已缴款
     * @param fstzs
     */
    public static FsResult<JkztResp> jiaokuanzt(Fstzs fstzs) {
        Map<String,Object> map = new HashMap<>();
        map.put("pay_code",fstzs.getJkm());
        String request = request("paybook.confirm.get", map);

        try {
            if(TextUtils.isEmpty(request)) {
                return FsResult.fail("网络异常,请重试！");
            }
            FsResp<JkztResp> resp = new Gson().fromJson(request, new TypeToken<FsResp<JkztResp>>() {
            }.getType());

            if(resp.errorMessage != null) {
                return FsResult.fail(resp.errorMessage.errorMsg);
            }
            return new FsResult<>(resp.message);
        } catch (Exception e) {
            System.out.println("激活请求异常！！");
            return FsResult.fail("激活请求异常！！" + e.getMessage());

        }
    }

    /**
     * 先开票，开票只返回状态
     * 开完之后再调用查询接口
     * @param fstzs
     * @param jbr
     * @return
     */
    public static FsResult<String> kaipiao(Fstzs fstzs,String jbr) {
        //1,stock.billno.get 获取电子票号
        Map<String,Object> mapPh = new HashMap<>();
        mapPh.put("place_code",getProp("fs-kpdbm"));//开票点编码
        mapPh.put("bill_batch_code",getProp("fs-pjdm"));// 票据代码
        String requestPh = request("stock.billno.get", mapPh);
        if(TextUtils.isEmpty(requestPh)) {
            return FsResult.fail("网络异常,请重试！");
        }
        FsResp<KaipiaoResp> respPh = new Gson().fromJson(requestPh, new TypeToken<FsResp<KaipiaoResp>>() {
        }.getType());
        //2,通过电子票号 开票
        if(respPh.errorMessage != null) {
            return FsResult.fail(respPh.errorMessage.errorMsg);
        }
        Map<String,Object> map = new HashMap<>();
        String kpLsh = System.currentTimeMillis() + "";
        map.put("serial_number",kpLsh);//业务流水号，不能重复
        map.put("place_code",getProp("fs-kpdbm"));//开票点编码
        map.put("bill_batch_code",getProp("fs-pjdm"));//电子票据代码
        map.put("bill_no",respPh.message.billNo);//电子票据代码

        List<Map<String,String>> payCodeInfo = new ArrayList<>();
        Map<String,String> payCodeInfoMap = new HashMap<>();
        payCodeInfoMap.put("pay_code",fstzs.getJkm());
        payCodeInfoMap.put("amount",fstzs.getYjje());
        payCodeInfo.add(payCodeInfoMap);
        map.put("pay_code_info",payCodeInfo);// 多张缴款书缴款完成后，开具电子票据需要传1张对应的缴款码
        String xml = getProp("EInvoiceContent");
        String eInvoiceID = new StringBuffer(respPh.message.billBatchCode + "-" + respPh.message.billNo).reverse().toString();
        xml = xml.replaceAll("\\{\\{EInvoiceID}}",eInvoiceID);
        xml = xml.replaceAll("\\{\\{EInvoiceCode}}",respPh.message.billBatchCode);
        xml = xml.replaceAll("\\{\\{EInvoiceNumber}}",respPh.message.billNo);
        xml = xml.replaceAll("\\{\\{random}}",((int)((Math.random()*9+1)*100000)) + "");
        xml = xml.replaceAll("\\{\\{yjje}}",fstzs.getYjje());
        xml = xml.replaceAll("\\{\\{kprq}}",new SimpleDateFormat("yyyyMMdd").format(new Date()));
        xml = xml.replaceAll("\\{\\{kpsj}}",new SimpleDateFormat("HH:mm:ss").format(new Date()));
        xml = xml.replaceAll("\\{\\{jkr}}",fstzs.getJkr());
        xml = xml.replaceAll("\\{\\{jbr}}",fstzs.getJksJbr());
        xml = xml.replaceAll("\\{\\{lsh}}",fstzs.getLsh());
        xml = xml.replaceAll("\\{\\{beizhu}}",fstzs.getFstzsXm().getBeizhu());
        xml = xml.replaceAll("\\{\\{jkm}}",fstzs.getJkm());
        xml = xml.replaceAll("\\{\\{yjmj}}",fstzs.getYjmj());
        xml = xml.replaceAll("\\{\\{itemCode}}",getProp("fs-sfxmbh"));

        try {
            String xmlBase64 = Base64.getEncoder().encodeToString(xml.getBytes("utf-8"));
            map.put("invoice_data",xmlBase64);// 电子票据头部、票面信息进行base64编码后内容。

            Map<String,String> signInfo = new HashMap<>();
            signInfo.put("value",FsSignUtil.sign(xml));//对电子票据头部、票面信息的签名值（签名原文为电子票据数据 Header和EInvoiceData内容），base64格式。
            signInfo.put("format","DETACH");//签名格式类型，目前固定 DETACH
            signInfo.put("algorithm","SM2");//摘要算法，默认SM2
            signInfo.put("time",new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));//签名时间
            map.put("sign_info",signInfo);// 签名信息节点A-3

            String request = request("invoice.e.issue.withsign.do", map);
            FsResp<CaozuoResp> resp = new Gson().fromJson(request, new TypeToken<FsResp<CaozuoResp>>() {
            }.getType());
            if(resp.errorMessage != null) {
                return FsResult.fail(resp.errorMessage.errorMsg);
            }

            if(resp.message != null) {
                return new FsResult<>(kpLsh);
            }
            return FsResult.fail("操作错误！" + new Gson().toJson(resp));


        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return FsResult.fail("操作异常" + e.getMessage());
        }

    }

    /**
     * 查询开票信息
     * @param kpLsh
     * @return
     */
    public static FsResult<KpResp> kaipiaoCx(String kpLsh) {
        String method = "invoice.jiangsu.get";
        Map<String,Object> map = new HashMap<>();
        map.put("serial_number",kpLsh);
        String request = request(method, map);
        FsResp<KpResp> resp = new Gson().fromJson(request,new TypeToken<FsResp<KpResp>>() {
        }.getType());
        if(resp.errorMessage != null) {
            return FsResult.fail(resp.errorMessage.errorMsg);
        }
        if(resp.message != null && !TextUtils.isEmpty(resp.message.url)) {
            return new FsResult<>(resp.message);
        }
        return FsResult.fail("开票未完成");
    }


    public static void main(String[] args) {
        String xml = "niasd{{pjdm}}12131";
        xml = xml.replaceAll("\\{\\{pjdm}}","AAAAAA");
        System.out.println(xml);
    }
}
