package com.jshx.fstzs.entity;

import com.jshx.common.utils.NumberToCN;
import com.jshx.core.base.entity.BaseModel;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.module.admin.entity.User;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.xmxxb.entity.Xmxxb;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author jinx@caoz.
 * 非税通知书-项目
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="FSTZS_XM")
public class FstzsXm extends BaseModel
{

	/**
	 * 0：默认：未生成
	 * 1：默认：已生成，待复核
	 * 2：复核通过
	 * 3：复核不通过
	 * 4：作废退回
	 * 5：已激活，全部成功，不再显示在已生成列表
	 * 6：已激活，但部分成功
	 */
	private Integer status;

	/**
	 * 备注
	 */
	private String beizhu;

	/**
	 * 交款人手机号
	 */
	private String mobile;

	/**
	 * 交款人开户行
	 */
	private String khh;

	/**
	 * 交款人账号
	 */
	private String zhanghao;

	/**
	 * 缴款人类型
	 * 单位、个人
	 */
	private String jkrlx;

	/**
	 * 经办人
	 * 点击生成非税通知书的人
	 */
	private String jbr;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	/**
	 * 受理编号
	 */
	private String slbh;

	/**
	 * 工程项目名称
	 */
	private String gcxmmc;

	/**
	 * 建设单位名成
	 */
	private String jsdwmc;

	/**
	 * 应缴金额
	 */
	private String yjje;
	/**
	 * 大写
	 */
	private String yjjedx;

	/**
	 * 复核意见
	 */
	private String fhyj;


	private Xmxxb xmxxb;

	/**
	 * 对应的收款人
	 */
	private Kpsjgl kpsjgl;

	/**
	 * 激活进度
	 * 成功数/总数
	 * 1/3 = 成功1个，总共3个
	 */
	private String jhjd;

	/**
	 * 项目是否缴销
	 */
	private Integer isJx;


	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getBeizhu() {
		return beizhu;
	}

	public void setBeizhu(String beizhu) {
		this.beizhu = beizhu;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getKhh() {
		return khh;
	}

	public void setKhh(String khh) {
		this.khh = khh;
	}

	public String getZhanghao() {
		return zhanghao;
	}

	public void setZhanghao(String zhanghao) {
		this.zhanghao = zhanghao;
	}

	public String getJbr() {
		return jbr;
	}

	public void setJbr(String jbr) {
		this.jbr = jbr;
	}

	public Integer getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Integer delFlag) {
		this.delFlag = delFlag;
	}

	public String getSlbh() {
		return slbh;
	}

	public void setSlbh(String slbh) {
		this.slbh = slbh;
	}

	public String getGcxmmc() {
		return gcxmmc;
	}

	public void setGcxmmc(String gcxmmc) {
		this.gcxmmc = gcxmmc;
	}

	public String getJsdwmc() {
		return jsdwmc;
	}

	public void setJsdwmc(String jsdwmc) {
		this.jsdwmc = jsdwmc;
	}

	public String getYjje() {
		return yjje;
	}

	public void setYjje(String yjje) {
		this.yjje = yjje;
	}

	public String getYjjedx() {
		return yjjedx;
	}

	public void setYjjedx(String yjjedx) {
		this.yjjedx = yjjedx;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=Xmxxb.class)
	@JoinColumn(name = "XMXXB_ZJ",updatable=false,insertable=true)
	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=Kpsjgl.class)
	@JoinColumn(name = "KPSJGL_ZJ",updatable=false,insertable=true)
	public Kpsjgl getKpsjgl() {
		return kpsjgl;
	}



	public void setKpsjgl(Kpsjgl kpsjgl) {
		this.kpsjgl = kpsjgl;
	}

	public String getFhyj() {
		return fhyj;
	}

	public void setFhyj(String fhyj) {
		this.fhyj = fhyj;
	}

	public String getJhjd() {
		return jhjd;
	}

	public void setJhjd(String jhjd) {
		this.jhjd = jhjd;
	}

	public String getJkrlx() {
		return jkrlx;
	}

	public void setJkrlx(String jkrlx) {
		this.jkrlx = jkrlx;
	}

	public Integer getIsJx() {
		return isJx;
	}

	public void setIsJx(Integer isJx) {
		this.isJx = isJx;
	}
}
