package com.jshx.fawen.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.dao.FawenReceiveinfoDao;
import com.jshx.fawen.entity.FawenReceiveinfo;


@Component("fawenReceiveinfoDao")
public class FawenReceiveinfoDaoImpl extends BaseDaoImpl implements FawenReceiveinfoDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findOaReceiveinfoByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findOaReceiveinfo(Map<String, Object> paraMap){
		return this.findListByHqlId("findOaReceiveinfoByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FawenReceiveinfo getById(String id)
	{
		return (FawenReceiveinfo)this.getObjectById(FawenReceiveinfo.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(FawenReceiveinfo oaReceiveinfo)
	{
		oaReceiveinfo.setId(null);
		//此处处理Blob对象（Blob对象不能直接insert）
		this.saveOrUpdateObject(oaReceiveinfo);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(FawenReceiveinfo oaReceiveinfo)
	{
		this.saveOrUpdateObject(oaReceiveinfo);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(FawenReceiveinfo.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		FawenReceiveinfo oaReceiveinfo = (FawenReceiveinfo)this.getObjectById(FawenReceiveinfo.class, id);
		oaReceiveinfo.setDelFlag(1);
		this.saveObject(oaReceiveinfo);
	}

	@Override
	public List<Object> queryQianshouList(Map<String, String> paramMap) {
		// TODO Auto-generated method stub
		return this.findListBySqlId("oaReceiveinfoDao_queryQianshouList", paramMap);
	}

	

	@Override
	public void deleteByEmailId(Map<String, Object> paramMap) {	
		this.executeUpdateBySqlId("deleteByEmailId", paramMap);
	}

	@Override
	public List findnotReadInfo(Map<String, String> paramMap) {
		// TODO Auto-generated method stub
		return this.findListBySqlId("notreadshouwen", paramMap);
	}

}
