package com.jshx.dxjl.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.dxjl.entity.Dxjl;
import com.jshx.dxjl.dao.DxjlDao;

@Component("dxjlDao")
public class DxjlDaoImpl extends BaseDaoImpl implements DxjlDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findDxjlByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findDxjl(Map<String, Object> paraMap){
		return this.findListByHqlId("findDxjlByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Dxjl getById(String id)
	{
		return (Dxjl)this.getObjectById(Dxjl.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Dxjl dxjl)
	{
		dxjl.setId(null);
		this.saveOrUpdateObject(dxjl);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Dxjl dxjl)
	{
		this.saveOrUpdateObject(dxjl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Dxjl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Dxjl dxjl = (Dxjl)this.getObjectById(Dxjl.class, id);
		dxjl.setDelFlag(1);
		this.saveObject(dxjl);
	}
}
