package com.jshx.billManager.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;

public interface BillManagerService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public Pagination findByIndeticurPage(Pagination page, Map<String, Object> paraMap);
	public List findByIndeticurPage(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public BillManager getById(String id);
	
	public Indeticur getIndeticurById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(BillManager model);
	
	public void save(Indeticur model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(BillManager model);
	public void update(Indeticur model);
	public void batchupdate(List<Indeticur> list);
	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
	
	public String findNo(Map<String, Object> paraMap);
	public int findcountByMap(Map<String, Object> paraMap);
	public Indeticur findIndeticurByNo(Map<String, Object> paraMap);
	
}
