package com.jshx.account.accountBank.service.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemDelay.dao.PaymentItemDelayDao;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelayFree.dao.PaymentItemDelayFreeDao;
import com.jshx.paymentItemDelayFree.entity.PaymentItemDelayFree;
import com.jshx.paymentItemDelayHis.dao.PaymentItemDelayHisDao;
import com.jshx.paymentItemDelayHis.entity.PaymentItemDelayHis;
import com.jshx.paymentItemHis.dao.PaymentItemHisDao;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemPending.dao.PaymentItemPendingDao;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.account.accountBank.dao.AccountBankAttachDao;
import com.jshx.account.accountBank.dao.AccountBankDao;
import com.jshx.account.accountBank.entity.AccountBank;
import com.jshx.account.accountBank.entity.AccountBankAttach;
import com.jshx.account.accountBank.service.AccountBankService;
import com.jshx.cktzs.dao.CktzsDao;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.common.utils.Constant;

@Service("accountBankService")
public class AccountBankServiceImpl extends BaseServiceImpl implements AccountBankService
{

	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("accountBankDao")
	private AccountBankDao accountBankDao;

	@Autowired() 
	@Qualifier("accountBankAttachDao")
	private AccountBankAttachDao accountBankAttachDao;
	
	@Autowired() 
	private PaymentItemPendingDao paymentItemPendingDao;
	
	@Autowired()
	private PaymentItemDelayDao paymentItemDelayDao;
	
	@Autowired() 
	private PaymentItemHisDao paymentItemHisDao;
	
	@Autowired()
	private PaymentItemDelayHisDao paymentItemDelayHisDao;
	
	@Autowired()
	private PaymentItemDelayFreeDao paymentItemDelayFreeDao;
	
	@Autowired() 
	private CktzsDao cktzsDao;
	@Autowired
	private DxpzService dxpzService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private SpjlbService spjlbService;
	@Autowired
	protected UserService userService;
	
	@Autowired
	private GenericManager genericManager;
	
	private PaymentItemDelayFree paymentItemDelayFree = new PaymentItemDelayFree();
	
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return accountBankDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public AccountBank getById(String id)
	{
		return accountBankDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 * @throws Exception 
	 */
	@Transactional
	public void save(AccountBank accountBank, String fileName, String originFileName)
	{
		try {
			accountBankDao.save(accountBank);
			if("0".equals(accountBank.getHasInvoice())){
				AccountBankAttach att = new AccountBankAttach();
				att.setDelFlag(0);
				att.setAttachname(originFileName);
				att.setAttachpath(fileName);
				att.setBizrowid(accountBank.getId());
				att.setCreateTime(new Date());
				accountBankAttachDao.save(att);
	        }
		}catch(Exception e){
			throw new BasalException(BasalException.ERROR, e.getMessage(), e);
		}finally {
		        String neirong=accountBank.getDevelopUnit()+":"+SysPropertiesUtil.qwfgf(String.valueOf(accountBank.getAmount()))+"银行已到账,请予办理!";
                        //9999代表全部单位代码
                    String phones=dxpzService.findbyywbm("004","9999");
                    if(!"".equals(phones)){
//                                    CommonAction.send(neirong, phones, "","银行");
                                    CommonAction.sendNewMessage(neirong, phones, "","银行");
                    }
                }
		
		
		
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(AccountBank accountBank)
	{
		accountBankDao.update(accountBank);
	}
	
	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(AccountBank accountBank, String fileName, String originFileName)
	{
		try {
			AccountBank model = accountBankDao.getById(accountBank.getId());
			model.setHasInvoice(accountBank.getHasInvoice());
			accountBankDao.update(model);
			if("0".equals(accountBank.getHasInvoice())){
				AccountBankAttach att = new AccountBankAttach();
				att.setDelFlag(0);
				att.setAttachname(originFileName);
				att.setAttachpath(fileName);
				att.setBizrowid(accountBank.getId());
				att.setCreateTime(new Date());
				accountBankAttachDao.save(att);
	        }
		}catch(Exception e){
			throw new BasalException(BasalException.ERROR, e.getMessage(), e);
		}
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=accountBankDao.findAccountBank(paraMap);
		
		accountBankDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    accountBankDao.deleteWithFlag(id);
			}
		}
	}

	/**
	 * 财务确认-待缴款
	 * @param orderId
	 * @param ids
	 * @param outcome
	 */
	@Transactional
	public void accountConfirmPending(String orderId, String ids, String outcome, String userId, IdentityService identityService, RuntimeService runtimeService) {
		try{
			//1:银行到账信息与项目信息关联
	    	//特殊情况：如果存在银行到账信息与待缴费项目信息多对多的情况，则需要将所有的银行到账信息与每条项目信息关联
	    	String[] idArray = ids.split("\\|");
			if(null != idArray)
			{
				for(String id : idArray)
				{
				    if(id!=null && !id.trim().equals(""))
				    {
				    	//将银行到账信息状态置为已审核
				    	AccountBank accountBank = accountBankDao.getById(id);
				    	accountBank.setStatus(Constant.AUDIT_STATUS_YES);
				    	accountBank.setOrderId(orderId);
				    	accountBankDao.update(accountBank);
				    }
				}
			}
			PaymentItemPending paymentItemPending = paymentItemPendingDao.getById(orderId);
			PaymentItemHis paymentItemHis = new PaymentItemHis();
			if(null != paymentItemPending){
				Xmxxb xmxxb=xmxxbService.getById(paymentItemPending.getXmbzj());
				xmxxb.setIsyjkrk("0");
				xmxxbService.update(xmxxb);
				//生成已缴款项目记录
				transformHis(paymentItemHis,paymentItemPending,ids);
				paymentItemHis.setOperatorId(userId);
				paymentItemHis.setIsCreateJfpz("0");
				paymentItemHis.setIsCwyz("0");

				if(Constant.HASINVOICE_YES.equals(outcome)){
					paymentItemHis.setPrintFlag(Constant.PRINT_PRIV);
				
				}else{
			    	//若无凭证，则需要通过预确认流程
		    		identityService.setAuthenticatedUserId(userId);
		    		ProcessInstance processInstance =runtimeService.startProcessInstanceByKey(Constant.PROCESS_ACCOUNT,paymentItemPending.getXmbzj());
		    		String aaa=processInstance.getProcessInstanceId();
		    		Spjlb s=spjlbService.getByslbh(paymentItemPending.getSlbh());
		    		if(null!=s){
		    	     	s.setYqrgzl(aaa);
		    	         User u=	userService.findUserById(userId);
		    	     	s.setYqrr(u.getDisplayName());
		    	     	s.setYqrsj(new Date());
		    	    	spjlbService.update(s);
		    		}
				}
				String ECN = "PZ"+xmxxb.getBllb()+xmxxb.getDwdm().toUpperCase()+genericManager.getSN("dzpz");
				paymentItemHis.setECN(ECN);
				//转入已缴款项目
				paymentItemHisDao.save(paymentItemHis);//???
				//清除待缴款项目
				paymentItemPendingDao.delete(paymentItemPending.getId()); 
				//若是催缴项目，则需要清除催缴记录
				Map<String,Object> map = new HashMap<String,Object>();
				map.put("slbh", paymentItemPending.getSlbh());
				List<Cktzs> list = cktzsDao.findCktzs(map);
				for(Cktzs cktzs : list){
					Cktzs ck=cktzs;
					ck.setIsjk("1");
					ck.setJksj(new Date());
					cktzsDao.update(ck);
//					cktzsDao.deleteWithFlag(cktzs.getId());
				}
				
//				String neirong=xmxxb.getSlbh()+"-"+paymentItemHis.getZyjje()+"已到账,请予办理";
//    			String phones=dxpzService.findbyywbm("004",xmxxb.getDwdm());
//    		     if(!"".equals(phones)){
//    		    	 User u=	userService.findUserByLoginId(userId);
//    		    	 if(null!=u){
//         		      CommonAction.send(neirong, phones, u.getDeptCode(),u.getDisplayName()); 
//    		    	 }
//    		     }
			}else{
				throw new BasalException(BasalException.ERROR,"系统异常,请联系管理员!");
			}
		}catch(Exception e){
			throw new BasalException(BasalException.ERROR, e.getMessage());
		}
	}
	
	/**
	 * 财务确认-缓缴款
	 * @param orderId
	 * @param ids
	 * @param outcome
	 */
	@Transactional
	public void accountConfirmDelay(String orderId, String ids, String userId, IdentityService identityService, RuntimeService runtimeService) {
		try{
	    	String[] idArray = ids.split("\\|");
	    	BigDecimal payAmount = new BigDecimal(0.00);
	    	PaymentItemDelay paymentItemDelay = paymentItemDelayDao.getById(orderId);
			if(null != idArray)
			{
				for(String id : idArray)
				{
				    if(id!=null && !id.trim().equals(""))
				    {
				    	//将银行到账信息状态置为已审核
				    	AccountBank accountBank = accountBankDao.getById(id);
				    	payAmount = payAmount.add(new BigDecimal(accountBank.getAmount()));
				    	accountBank.setStatus(Constant.AUDIT_STATUS_YES);
				    	accountBank.setOrderId(orderId);
				    	accountBankDao.update(accountBank);
				    	//将到账信息放入台账记录表内
				    	paymentItemDelayFree.setDelFlag(0);
				    	paymentItemDelayFree.setRelateId(orderId);
				    	paymentItemDelayFree.setFreeAmount(accountBank.getAmount().toString());
				    	paymentItemDelayFree.setRemark(accountBank.getRemark());
				    	paymentItemDelayFree.setType(Constant.TYPE_PAY);
				    	if(null != paymentItemDelay){
				    		paymentItemDelayFree.setDwdm(paymentItemDelay.getDwdm());//新增单位代码
				    	}
						paymentItemDelayFreeDao.save(paymentItemDelayFree);
				    }
				}
			}
			//登记核销需要台账复核后方可扣减金额
			identityService.setAuthenticatedUserId(userId);
            runtimeService.startProcessInstanceByKey(Constant.PROCESS_TZCL,paymentItemDelayFree.getId());//到账项目主键
			PaymentItemDelayHis paymentItemDelayHis = new PaymentItemDelayHis();
			if(null != paymentItemDelay){
				//生成已缴款项目记录
				transformDelayHis(paymentItemDelayHis,paymentItemDelay,ids);
				paymentItemDelayHis.setPrintFlag(Constant.PRINT_PRIV);
				paymentItemDelayHis.setSjje(payAmount.toString());
				//转入已缴款项目
				paymentItemDelayHisDao.save(paymentItemDelayHis);
				
				//银行到账发短信
//				String neirong=paymentItemDelay.getSlbh()+"_"+paymentItemDelayFree.getFreeAmount()+"已到账,请予办理";
//				String phones=dxpzService.findbyywbm("004",paymentItemDelay.getDwdm());
//				if(!"".equals(phones)){
//					User u=	userService.findUserByLoginId(userId);
//					if(null!=u){
//						CommonAction.send(neirong, phones, u.getDeptCode(),u.getDisplayName()); 
//					}
//				}
			}else{
				throw new BasalException(BasalException.ERROR,"系统异常,请联系管理员!");
			}
			
				
			
		}catch(Exception e){
			throw new BasalException(BasalException.ERROR, e.getMessage());
		}
	}
	
	/**
	 * 生成历史记录
	 * @param paymentItemHis
	 * @param paymentItemPending
	 */
	private void transformHis(PaymentItemHis paymentItemHis,PaymentItemPending paymentItemPending,String ids){
		paymentItemHis.setDelFlag(0);
		paymentItemHis.setSlbh(paymentItemPending.getSlbh());
		paymentItemHis.setXmbzj(paymentItemPending.getXmbzj());
		paymentItemHis.setDwmc(paymentItemPending.getDwmc());
		paymentItemHis.setXmmc(paymentItemPending.getXmmc());
		paymentItemHis.setMjyj(paymentItemPending.getMjyj());
		paymentItemHis.setDkxmslh(paymentItemPending.getDkxmslh());
		paymentItemHis.setZsdw(paymentItemPending.getZsdw());
		paymentItemHis.setDwdm(paymentItemPending.getDwdm());
		paymentItemHis.setDkmj(paymentItemPending.getDkmj());
		paymentItemHis.setCsmj(paymentItemPending.getCsmj());
		paymentItemHis.setPtyjmj(paymentItemPending.getPtyjmj());
		paymentItemHis.setPtyjje(paymentItemPending.getPtyjje());
		paymentItemHis.setPtymmj(paymentItemPending.getPtymmj());
		paymentItemHis.setPtymje(paymentItemPending.getPtymje());
		paymentItemHis.setRfyjmj(paymentItemPending.getRfyjmj());
		paymentItemHis.setRfymmj(paymentItemPending.getRfymmj());
		paymentItemHis.setRfyjje(paymentItemPending.getRfyjje());
		paymentItemHis.setRfymje(paymentItemPending.getRfymje());
		paymentItemHis.setXqyjmj(paymentItemPending.getXqyjmj());
		paymentItemHis.setXqymmj(paymentItemPending.getXqymmj());
		paymentItemHis.setXqyjje(paymentItemPending.getXqyjje());
		paymentItemHis.setXqymje(paymentItemPending.getXqymje());
		paymentItemHis.setByyjmj(paymentItemPending.getByyjmj());
		paymentItemHis.setByymmj(paymentItemPending.getByymmj());
		paymentItemHis.setByyjje(paymentItemPending.getByyjje());
		paymentItemHis.setByymje(paymentItemPending.getByymje());
		paymentItemHis.setZyjje(paymentItemPending.getZyjje());
		paymentItemHis.setZymje(paymentItemPending.getZymje());
		paymentItemHis.setWarnFlag(paymentItemPending.getWarnFlag());
		paymentItemHis.setLockFlag(Constant.STATUS_LOCK_1);//项目默认有锁
		//关联的缴费凭证
		paymentItemHis.setAccountbankId(ids);
		paymentItemHis.setNonTaxStatus(Constant.NON_TAX_STATUS_0);
		paymentItemHis.setIsPrintJfpz("0");//默认缴费凭证未打印
	}
	
	/**
	 * 生成历史记录
	 * @param paymentItemHis
	 * @param paymentItemPending
	 */
	private void transformDelayHis(PaymentItemDelayHis paymentItemDelayHis,PaymentItemDelay paymentItemDelay,String ids){
		paymentItemDelayHis.setDelFlag(0);
		paymentItemDelayHis.setSlbh(paymentItemDelay.getSlbh());
		paymentItemDelayHis.setXmbzj(paymentItemDelay.getXmbzj());
		paymentItemDelayHis.setDwmc(paymentItemDelay.getDwmc());
		paymentItemDelayHis.setXmmc(paymentItemDelay.getXmmc());
		paymentItemDelayHis.setZsdw(paymentItemDelay.getZsdw());
		paymentItemDelayHis.setDwdm(paymentItemDelay.getDwdm());
		paymentItemDelayHis.setCsmj(paymentItemDelay.getCsmj());
		//关联的缴费凭证
		paymentItemDelayHis.setAccountbankId(ids);
		paymentItemDelayHis.setNonTaxStatus(Constant.NON_TAX_STATUS_0);
	}
	
	public PaymentItemDelayFree getPaymentItemDelayFree() {
		return paymentItemDelayFree;
	}

	public void setPaymentItemDelayFree(PaymentItemDelayFree paymentItemDelayFree) {
		this.paymentItemDelayFree = paymentItemDelayFree;
	}
}
