/*     */ package cn.com.jshx.smgp.pdu;
/*     */ 
/*     */ import cn.com.jshx.smgp.bean.Submit;
/*     */ import cn.com.jshx.smgp.protocol.TlvId;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class WapPushPdu
/*     */ {
/*  26 */   private static byte[] WapPushUdhi = { 5, 
/*  27 */     4, 
/*  28 */     11, 
/*  29 */     -124, 
/*  30 */     35, 
/*  31 */     -16 };
/*     */ 
/*  41 */   private static byte[] WapPushHeader2 = { 
/*  42 */     37, 
/*  43 */     6, 
/*  44 */     10, 
/*  45 */     3, -82, -127, -22, 
/*  46 */     -81, -126, 
/*  47 */     -115, -39, 
/*  48 */     -76, -124 };
/*     */ 
/*  51 */   private static byte[] WapPushIndicator = { 2, 
/*  52 */     5, 
/*  53 */     106, 
/*  55 */     0, 69, 
/*  56 */     -58, 
/*  57 */     8, 
/*  58 */     12, 
/*  59 */     3 };
/*     */ 
/*  60 */   private static byte[] WapPushDisplayTextHeader = { 
/*  61 */     0, 1, 
/*  62 */     3 };
/*     */ 
/*  65 */   private static byte[] EndOfWapPush = { 
/*  67 */     0, 1, 
/*  68 */     1 };
/*     */ 
/*     */   public static Submit[] getWapPushSubmit(String desc, String url, Submit submit)
/*     */   {
/*  73 */     Submit[] arraySubmit = (Submit[])null;
/*     */     try
/*     */     {
/*  77 */       byte[] PushBody = getWapPushBody(desc, url);
/*     */ 
/*  79 */       if (PushBody.length < 128) {
/*  80 */         arraySubmit = new Submit[1];
/*  81 */         arraySubmit[0] = submit;
/*  82 */         arraySubmit[0].AddTlv(TlvId.TP_udhi, "1");
/*  83 */         arraySubmit[0].AddTlv(TlvId.TP_pid, "0");
/*     */ 
/*  85 */         arraySubmit[0].setMsgFormat(4);
/*  86 */         arraySubmit[0].setServiceID("WAP");
/*  87 */         arraySubmit[0].AddTlv(TlvId.SubmitMsgType, "1");
/*  88 */         arraySubmit[0].setMsgContent(mergeByteArray(getWapPushHeader(1, 1), PushBody));
/*     */       } else {
/*  90 */         Vector contentArray = SplitContent(PushBody);
/*  91 */         arraySubmit = new Submit[contentArray.size()];
/*  92 */         for (int i = 0; i < contentArray.size(); i++) {
/*  93 */           arraySubmit[i] = submit;
/*  94 */           arraySubmit[i].AddTlv(TlvId.TP_udhi, "1");
/*  95 */           arraySubmit[i].AddTlv(TlvId.TP_pid, "0");
/*  96 */           arraySubmit[i].setMsgFormat(4);
/*  97 */           arraySubmit[i].setServiceID("WAP");
/*     */ 
/*  99 */           arraySubmit[i].AddTlv(TlvId.SubmitMsgType, "1");
/* 100 */           arraySubmit[i].setMsgContent(mergeByteArray(getWapPushHeader(contentArray.size(), i + 1), (byte[])contentArray.get(i)));
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 107 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 110 */     return arraySubmit;
/*     */   }
/*     */ 
/*     */   public static Submit[] getWapPushSubmit(String desc, String url, String srcTermid, String destTermid, String chargeTermid, String productID) {
/* 114 */     Submit[] arraySubmit = (Submit[])null;
/*     */     try
/*     */     {
/* 118 */       byte[] PushBody = getWapPushBody(desc, url);
/*     */ 
/* 120 */       if (PushBody.length < 128) {
/* 121 */         arraySubmit = new Submit[1];
/* 122 */         arraySubmit[0] = new Submit();
/* 123 */         arraySubmit[0].AddTlv(TlvId.TP_udhi, "1");
/* 124 */         arraySubmit[0].setMsgFormat(4);
/* 125 */         arraySubmit[0].setSrcTermid(srcTermid);
/* 126 */         arraySubmit[0].setChargeTermid(chargeTermid);
/* 127 */         arraySubmit[0].setDestTermid(destTermid);
/* 128 */         arraySubmit[0].setMsgContent(mergeByteArray(getWapPushHeader(1, 1), PushBody));
/* 129 */         arraySubmit[0].setProductID(productID);
/* 130 */         arraySubmit[0].setMsgType(7);
/*     */       } else {
/* 132 */         Vector contentArray = SplitContent(PushBody);
/* 133 */         arraySubmit = new Submit[contentArray.size()];
/* 134 */         for (int i = 0; i < contentArray.size(); i++) {
/* 135 */           arraySubmit[i] = new Submit();
/* 136 */           arraySubmit[i].AddTlv(TlvId.TP_udhi, "1");
/* 137 */           arraySubmit[i].setMsgFormat(4);
/* 138 */           arraySubmit[i].setSrcTermid(srcTermid);
/* 139 */           arraySubmit[i].setChargeTermid(chargeTermid);
/* 140 */           arraySubmit[i].setDestTermid(destTermid);
/* 141 */           arraySubmit[i].setMsgContent(mergeByteArray(getWapPushHeader(contentArray.size(), i + 1), (byte[])contentArray.get(i)));
/* 142 */           arraySubmit[i].setProductID(productID);
/* 143 */           arraySubmit[i].setMsgType(7);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 150 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 153 */     return arraySubmit;
/*     */   }
/*     */ 
/*     */   private static Vector<byte[]> SplitContent(byte[] content) {
/* 157 */     ByteArrayInputStream buf = new ByteArrayInputStream(content);
/* 158 */     Vector tmpv = new Vector();
/*     */ 
/* 160 */     int msgCount = content.length / 128 + 1;
/* 161 */     int LeftLen = content.length;
/* 162 */     for (int i = 0; i < msgCount; i++) {
/* 163 */       byte[] tmp = new byte[''];
/* 164 */       if (LeftLen < 128)
/* 165 */         tmp = new byte[LeftLen];
/*     */       try {
/* 167 */         buf.read(tmp);
/* 168 */         tmpv.add(tmp);
/*     */       }
/*     */       catch (IOException e) {
/* 171 */         e.printStackTrace();
/*     */       }
/* 173 */       LeftLen -= tmp.length;
/*     */     }
/* 175 */     return tmpv;
/*     */   }
/*     */ 
/*     */   public static byte[] getWapPushHeader(int total, int cur) {
/* 179 */     byte[] wappushUdhi = WapPushUdhi;
/* 180 */     byte[] longsmsUdhi = getLongSmsUdhi(total, cur);
/* 181 */     int udhiLength = wappushUdhi.length + longsmsUdhi.length;
/* 182 */     byte[] lenHeader = new byte[1];
/* 183 */     lenHeader[0] = ((byte)udhiLength);
/* 184 */     return mergeByteArray(lenHeader, mergeByteArray(wappushUdhi, 
/* 185 */       longsmsUdhi));
/*     */   }
/*     */ 
/*     */   public static byte[] getWapPushBody(String desc, String url) throws UnsupportedEncodingException {
/* 189 */     return mergeByteArray(mergeByteArray(mergeByteArray(mergeByteArray(mergeByteArray(WapPushHeader2, WapPushIndicator), url.getBytes("UTF-8")), WapPushDisplayTextHeader), desc.getBytes("UTF-8")), EndOfWapPush);
/*     */   }
/*     */ 
/*     */   private static byte[] mergeByteArray(byte[] by1, byte[] by2) {
/* 193 */     byte[] tmpbyteNew = new byte[by1.length + by2.length];
/* 194 */     System.arraycopy(by1, 0, tmpbyteNew, 0, by1.length);
/* 195 */     System.arraycopy(by2, 0, tmpbyteNew, by1.length, by2.length);
/* 196 */     return tmpbyteNew;
/*     */   }
/*     */ 
/*     */   private static byte[] getLongSmsUdhi(int total, int cur) {
/* 200 */     byte[] longSmsUdhi = { 
/* 201 */       0, 3, 
/* 203 */       0, (byte)total, 
/* 204 */       (byte)cur };
/*     */ 
/* 206 */     return longSmsUdhi;
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.pdu.WapPushPdu
 * JD-Core Version:    0.6.2
 */